/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.httpquery;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.trino.plugin.httpquery.HttpEventListenerEventType;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HttpEventListenerConfig {
    private int retryCount;
    private Duration retryDelay = Duration.valueOf((String)"1s");
    private double backoffBase = 2.0;
    private Duration maxDelay = Duration.valueOf((String)"1m");
    private final EnumSet<HttpEventListenerEventType> loggedEvents = EnumSet.noneOf(HttpEventListenerEventType.class);
    private String ingestUri;
    private Map<String, String> httpHeaders = ImmutableMap.of();

    @ConfigDescription(value="Will log io.trino.spi.eventlistener.QueryCreatedEvent")
    @Config(value="http-event-listener.log-created")
    public HttpEventListenerConfig setLogCreated(boolean logCreated) {
        if (logCreated) {
            this.loggedEvents.add(HttpEventListenerEventType.QUERY_CREATED);
        }
        return this;
    }

    public boolean getLogCreated() {
        return this.loggedEvents.contains((Object)HttpEventListenerEventType.QUERY_CREATED);
    }

    @ConfigDescription(value="Will log io.trino.spi.eventlistener.QueryCompletedEvent")
    @Config(value="http-event-listener.log-completed")
    public HttpEventListenerConfig setLogCompleted(boolean logCompleted) {
        if (logCompleted) {
            this.loggedEvents.add(HttpEventListenerEventType.QUERY_COMPLETED);
        }
        return this;
    }

    public boolean getLogCompleted() {
        return this.loggedEvents.contains((Object)HttpEventListenerEventType.QUERY_COMPLETED);
    }

    @ConfigDescription(value="Will log io.trino.spi.eventlistener.SplitCompletedEvent")
    @Config(value="http-event-listener.log-split")
    public HttpEventListenerConfig setLogSplit(boolean logSplit) {
        if (logSplit) {
            this.loggedEvents.add(HttpEventListenerEventType.QUERY_SPLIT);
        }
        return this;
    }

    public boolean getLogSplit() {
        return this.loggedEvents.contains((Object)HttpEventListenerEventType.QUERY_SPLIT);
    }

    @NotNull
    public String getIngestUri() {
        return this.ingestUri;
    }

    @ConfigDescription(value="URL of receiving server. Explicitly set the scheme https:// to use symmetric encryption")
    @Config(value="http-event-listener.connect-ingest-uri")
    public HttpEventListenerConfig setIngestUri(String ingestUri) throws URISyntaxException {
        this.ingestUri = ingestUri;
        return this;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    @ConfigDescription(value="List of custom custom HTTP headers provided as: \"Header-Name-1: header value 1, Header-Value-2: header value 2, ...\" ")
    @Config(value="http-event-listener.connect-http-headers")
    public HttpEventListenerConfig setHttpHeaders(List<String> httpHeaders) {
        try {
            this.httpHeaders = httpHeaders.stream().collect(Collectors.toUnmodifiableMap(kvs -> kvs.split(":", 2)[0], kvs -> kvs.split(":", 2)[1]));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Cannot parse http headers from property http-event-listener.connect-http-headers; value provided was %s, expected format is \"Header-Name-1: header value 1, Header-Value-2: header value 2, ...\"", String.join((CharSequence)", ", httpHeaders)), e);
        }
        return this;
    }

    @ConfigDescription(value="Number of retries on server error")
    @Config(value="http-event-listener.connect-retry-count")
    public HttpEventListenerConfig setRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    @Min(value=0L, message="Retry count must be a positive value. Use 0 or leave empty for no retries.")
    public @Min(value=0L, message="Retry count must be a positive value. Use 0 or leave empty for no retries.") int getRetryCount() {
        return this.retryCount;
    }

    @ConfigDescription(value="Delay in seconds between retries")
    @Config(value="http-event-listener.connect-retry-delay")
    public HttpEventListenerConfig setRetryDelay(Duration retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    @ConfigDescription(value="Base used for exponential backoff when retying on server error. Formula is attemptDelay = retryDelay * backoffBase ^ attemptCount. Attempt counting starts from 0. Leave empty or set to 1 to disable.")
    @Config(value="http-event-listener.connect-backoff-base")
    public HttpEventListenerConfig setBackoffBase(double backoffBase) {
        this.backoffBase = backoffBase;
        return this;
    }

    @Min(value=1L, message="Exponential base must be a positive, non-zero integer.")
    public @Min(value=1L, message="Exponential base must be a positive, non-zero integer.") double getBackoffBase() {
        return this.backoffBase;
    }

    @ConfigDescription(value="Maximum delay between retries. This should be used with exponential backoff.")
    @Config(value="http-event-listener.connect-max-delay")
    public HttpEventListenerConfig setMaxDelay(Duration maxDelay) {
        this.maxDelay = maxDelay;
        return this;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }
}

