/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.binding.springmvc;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.Utilities;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.transport.HttpHeaderTransport;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public final class TraceeInterceptor
implements HandlerInterceptor {
    private final TraceeBackend backend;
    private final HttpHeaderTransport httpHeaderSerialization;
    private String outgoingHeaderName = "TPIC";
    private String incomingHeaderName = "TPIC";
    private String profileName;

    public TraceeInterceptor() {
        this(Tracee.getBackend());
    }

    protected TraceeInterceptor(TraceeBackend backend) {
        this.backend = backend;
        this.httpHeaderSerialization = new HttpHeaderTransport();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) {
        Enumeration headers;
        TraceeFilterConfiguration configuration = this.backend.getConfiguration(this.profileName);
        if (configuration.shouldProcessContext(TraceeFilterConfiguration.Channel.IncomingRequest) && (headers = request.getHeaders(this.incomingHeaderName)) != null && headers.hasMoreElements()) {
            Map parsedContext = this.httpHeaderSerialization.parse(Collections.list(headers));
            this.backend.putAll(configuration.filterDeniedParams(parsedContext, TraceeFilterConfiguration.Channel.IncomingResponse));
        }
        Utilities.generateInvocationIdIfNecessary((TraceeBackend)this.backend);
        HttpSession session = request.getSession(false);
        if (session != null) {
            Utilities.generateSessionIdIfNecessary((TraceeBackend)this.backend, (String)session.getId());
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) {
        TraceeFilterConfiguration configuration = this.backend.getConfiguration(this.profileName);
        if (!this.backend.isEmpty() && configuration.shouldProcessContext(TraceeFilterConfiguration.Channel.OutgoingResponse)) {
            Map filteredContext = configuration.filterDeniedParams(this.backend.copyToMap(), TraceeFilterConfiguration.Channel.OutgoingResponse);
            response.setHeader(this.outgoingHeaderName, this.httpHeaderSerialization.render(filteredContext));
        }
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) {
        this.backend.clear();
    }

    public void setOutgoingHeaderName(String outgoingHeaderName) {
        this.outgoingHeaderName = outgoingHeaderName;
    }

    public void setIncomingHeaderName(String incomingHeaderName) {
        this.incomingHeaderName = incomingHeaderName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }
}

