/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.binding.httpcomponents;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.transport.HttpHeaderTransport;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.protocol.HttpContext;

public class TraceeHttpResponseInterceptor
implements HttpResponseInterceptor {
    private final TraceeBackend backend;
    private final HttpHeaderTransport transportSerialization;
    private final String profile;

    public TraceeHttpResponseInterceptor() {
        this("default");
    }

    public TraceeHttpResponseInterceptor(String profile) {
        this(Tracee.getBackend(), profile);
    }

    TraceeHttpResponseInterceptor(TraceeBackend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
        this.transportSerialization = new HttpHeaderTransport();
    }

    public final void process(HttpResponse response, HttpContext context) {
        TraceeFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        Header[] responseHeaders = response.getHeaders("TPIC");
        if (responseHeaders != null && responseHeaders.length > 0 && filterConfiguration.shouldProcessContext(TraceeFilterConfiguration.Channel.IncomingResponse)) {
            ArrayList<String> stringTraceeHeaders = new ArrayList<String>();
            for (Header header : responseHeaders) {
                stringTraceeHeaders.add(header.getValue());
            }
            this.backend.putAll(filterConfiguration.filterDeniedParams(this.transportSerialization.parse(stringTraceeHeaders), TraceeFilterConfiguration.Channel.IncomingResponse));
        }
    }
}

