/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.binding.httpcomponents;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.transport.HttpHeaderTransport;
import java.util.Map;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class TraceeHttpRequestInterceptor
implements HttpRequestInterceptor {
    private final TraceeBackend backend;
    private final HttpHeaderTransport transportSerialization;
    private final String profile;

    public TraceeHttpRequestInterceptor() {
        this("default");
    }

    public TraceeHttpRequestInterceptor(String profile) {
        this(Tracee.getBackend(), profile);
    }

    TraceeHttpRequestInterceptor(TraceeBackend backend, String profile) {
        this.backend = backend;
        this.transportSerialization = new HttpHeaderTransport();
        this.profile = profile;
    }

    public final void process(HttpRequest httpRequest, HttpContext httpContext) {
        TraceeFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceeFilterConfiguration.Channel.OutgoingRequest)) {
            Map filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), TraceeFilterConfiguration.Channel.OutgoingRequest);
            httpRequest.setHeader("TPIC", this.transportSerialization.render(filteredParams));
        }
    }
}

