/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.gateway.router.dispatch;

import io.tiklab.core.context.BeanFactoryContext;
import io.tiklab.gateway.router.util.RouterUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileItemFactory;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.RequestContext;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RouteDispatchForUpload {
    private static Logger logger = LoggerFactory.getLogger(RouteDispatchForUpload.class);
    private final long MAX_SIZE = Integer.MIN_VALUE;

    public RestTemplate getRestTemplate() {
        return (RestTemplate)BeanFactoryContext.getBeanFactory().getBean(RestTemplate.class);
    }

    public void dispatch(HttpServletRequest req, HttpServletResponse res, String toUrl) throws IOException, ServletException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(4096);
        factory.setRepository(new File("./uploadFileTemp"));
        ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)factory);
        fileUpload.setHeaderEncoding("utf-8");
        fileUpload.setSizeMax(Integer.MIN_VALUE);
        List fileItemList = null;
        try {
            fileItemList = fileUpload.parseRequest((RequestContext)req);
        }
        catch (FileUploadException e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u89e3\u6790\u9519\u8bef,{}", (Object)e.getMessage());
            throw new ServletException((Throwable)e);
        }
        if (fileItemList == null || fileItemList.size() == 0) {
            throw new ServletException("\u6ca1\u6709\u6587\u4ef6");
        }
        ArrayList<1> fileList = new ArrayList<1>();
        for (final FileItem fileItem : fileItemList) {
            ByteArrayResource byteArr = new ByteArrayResource(fileItem.get()){

                public String getFilename() throws IllegalStateException {
                    return fileItem.getName();
                }
            };
            fileList.add(byteArr);
        }
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        if (fileList.size() == 1) {
            parts.add((Object)"file", fileList.get(0));
        } else {
            parts.add((Object)"file", fileList);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpMethod httpMethod = RouterUtils.getMehtod(req);
        HttpEntity mutiReq = new HttpEntity((Object)parts, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.getRestTemplate().exchange(toUrl, httpMethod, mutiReq, byte[].class, new HashMap());
        if (responseEntity.hasBody()) {
            try {
                ServletOutputStream outputStream = res.getOutputStream();
                outputStream.flush();
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
    }
}

