/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.gateway.router.dispatch;

import io.tiklab.core.context.BeanFactoryContext;
import io.tiklab.core.exception.SystemException;
import io.tiklab.gateway.router.util.HeaderBuilders;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestTemplate;

public class RouteDispatchForJson {
    private static Logger logger = LoggerFactory.getLogger(RouteDispatchForJson.class);

    public RestTemplate getRestTemplate() {
        return (RestTemplate)BeanFactoryContext.getBeanFactory().getBean(RestTemplate.class);
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response, String dispatchUrl) {
        block4: {
            try {
                RequestEntity<byte[]> requestEntity = this.buildRequestEntityForJson(request, dispatchUrl);
                ResponseEntity responseEntity = this.getRestTemplate().exchange(requestEntity, byte[].class);
                HttpHeaders httpHeaders = responseEntity.getHeaders();
                response.setContentType(httpHeaders.getContentType().toString());
                if (!responseEntity.hasBody()) break block4;
                try {
                    ServletOutputStream outputStream = response.getOutputStream();
                    outputStream.write((byte[])responseEntity.getBody());
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    RequestEntity<byte[]> buildRequestEntityForJson(HttpServletRequest request, String url) throws URISyntaxException, IOException {
        String method = request.getMethod();
        HttpMethod httpMethod = HttpMethod.resolve((String)method);
        HttpHeaders headers = HeaderBuilders.buildRequestHeaders(request);
        ServletInputStream inputStream = request.getInputStream();
        byte[] body = StreamUtils.copyToByteArray((InputStream)inputStream);
        RequestEntity requestEntity = new RequestEntity((Object)body, (MultiValueMap)headers, httpMethod, new URI(url));
        return requestEntity;
    }
}

