/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.gateway.router.dispatch;

import io.tiklab.core.context.BeanFactoryContext;
import io.tiklab.core.exception.SystemException;
import io.tiklab.gateway.router.util.HeaderBuilders;
import io.tiklab.gateway.router.util.RouterUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RouteDispatchForFormData {
    private static Logger logger = LoggerFactory.getLogger(RouteDispatchForFormData.class);

    public RestTemplate getRestTemplate() {
        return (RestTemplate)BeanFactoryContext.getBeanFactory().getBean(RestTemplate.class);
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response, String dispatchUrl) {
        block4: {
            try {
                HttpEntity<MultiValueMap<String, String>> requestEntity = this.buildRequestEntityForFormData(request, dispatchUrl);
                HttpMethod httpMethod = RouterUtils.getMehtod(request);
                ResponseEntity responseEntity = this.getRestTemplate().exchange(dispatchUrl, httpMethod, requestEntity, byte[].class, new Object[0]);
                HttpHeaders httpHeaders = responseEntity.getHeaders();
                response.setContentType(httpHeaders.getContentType().toString());
                if (!responseEntity.hasBody()) break block4;
                try {
                    ServletOutputStream outputStream = response.getOutputStream();
                    outputStream.write((byte[])responseEntity.getBody());
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw new SystemException((Throwable)e);
                }
            }
            catch (Exception e) {
                throw new SystemException((Throwable)e);
            }
        }
    }

    HttpEntity<MultiValueMap<String, String>> buildRequestEntityForFormData(HttpServletRequest request, String url) throws URISyntaxException, IOException {
        String method = request.getMethod();
        HttpMethod httpMethod = HttpMethod.resolve((String)method);
        HttpHeaders headers = HeaderBuilders.buildRequestHeaders(request);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String[] values;
            String key = (String)entry.getKey();
            for (String value : values = (String[])entry.getValue()) {
                params.add((Object)key, (Object)value);
            }
        }
        HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        return requestEntity;
    }
}

