/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.gateway.router;

import io.tiklab.core.exception.SystemException;
import io.tiklab.gateway.router.config.RouterConfig;
import io.tiklab.gateway.router.config.RouterItem;
import io.tiklab.gateway.router.dispatch.RouteDispatchForFormData;
import io.tiklab.gateway.router.dispatch.RouteDispatchForFormUrl;
import io.tiklab.gateway.router.dispatch.RouteDispatchForJson;
import io.tiklab.gateway.router.dispatch.RouteDispatchForUpload;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class Router {
    private static Logger logger = LoggerFactory.getLogger(Router.class);
    RouterConfig routerConfig;
    RouteDispatchForFormUrl routeDispatchForFormUrl = new RouteDispatchForFormUrl();
    RouteDispatchForFormData routeDispatchForFormData = new RouteDispatchForFormData();
    RouteDispatchForJson routeDispatchForJson = new RouteDispatchForJson();
    RouteDispatchForUpload routeDispatchForUpload = new RouteDispatchForUpload();

    public Router setRouterConfig(RouterConfig routerConfig) {
        this.routerConfig = routerConfig;
        return this;
    }

    public RouterConfig getRouterConfig() {
        return this.routerConfig;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) {
        String url = request.getRequestURI();
        String disaptchUrl = this.getDisaptchUrl(request, response);
        String contentType = request.getContentType();
        if (contentType == null) {
            contentType = "application/x-www-form-urlencoded";
        }
        if (contentType.toLowerCase().contains("application/x-www-form-urlencoded")) {
            this.routeDispatchForFormUrl.dispatch(request, response, disaptchUrl);
        } else if (contentType.toLowerCase().contains("multipart/form-data")) {
            this.routeDispatchForFormData.dispatch(request, response, disaptchUrl);
        } else if (contentType.toLowerCase().contains("application/json")) {
            this.routeDispatchForJson.dispatch(request, response, disaptchUrl);
        } else {
            throw new SystemException("unsupport request contentType:" + contentType);
        }
    }

    public boolean isNeedDispatch(HttpServletRequest request, HttpServletResponse response) {
        if (this.routerConfig == null) {
            return false;
        }
        String url = request.getRequestURI();
        List<RouterItem> routers = this.routerConfig.getRouterItems();
        List<RouterItem> preRouters = this.routerConfig.getPreRouterItems();
        if (CollectionUtils.isEmpty(routers) && CollectionUtils.isEmpty(preRouters)) {
            return false;
        }
        for (RouterItem router : routers) {
            if (!url.equals(router.getUrl())) continue;
            return true;
        }
        for (RouterItem preRouter : preRouters) {
            if (!url.startsWith(preRouter.getUrl())) continue;
            return true;
        }
        return false;
    }

    String getDisaptchUrl(HttpServletRequest request, HttpServletResponse response) {
        String url = request.getRequestURI();
        List<RouterItem> routers = this.routerConfig.getRouterItems();
        List<RouterItem> preRouters = this.routerConfig.getPreRouterItems();
        String target = null;
        for (RouterItem router : routers) {
            if (!url.equals(router.getUrl())) continue;
            target = router.getTarget();
        }
        for (RouterItem preRouter : preRouters) {
            if (!url.startsWith(preRouter.getUrl())) continue;
            target = preRouter.getTarget();
        }
        if (target != null) {
            String dispatchUrl = target.concat(url);
            return dispatchUrl;
        }
        return null;
    }

    public void destroy() {
    }
}

