/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.gateway;

import io.tiklab.gateway.filter.Filter;
import io.tiklab.gateway.router.Router;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayFilter
implements javax.servlet.Filter {
    public static final Logger logger = LoggerFactory.getLogger(GatewayFilter.class);
    Router router = new Router();
    List<Filter> filters = new ArrayList<Filter>();

    public GatewayFilter setRouter(Router router) {
        this.router = router;
        return this;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public GatewayFilter addFilter(Filter filter) {
        this.filters.add(filter);
        return this;
    }

    public GatewayFilter addFilters(List<Filter> filters) {
        this.filters.addAll(filters);
        return this;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String requestMethod = httpRequest.getMethod();
        String url = httpRequest.getRequestURI();
        List<Filter> filterList = this.getFilters();
        for (Filter handler : filterList) {
            handler.handle(httpRequest, httpResponse);
        }
        boolean isNeedDispatch = this.router.isNeedDispatch(httpRequest, httpResponse);
        if (isNeedDispatch) {
            this.router.handle(httpRequest, httpResponse);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

