/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.UpdateBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UpdateBuilder.TemplateMutator", generator="Immutables")
@Immutable
public final class ImmutableTemplateMutator
implements UpdateBuilder.TemplateMutator {
    private final String templateId;
    private final String name;
    private final String description;
    private final String content;
    private final String type;

    private ImmutableTemplateMutator(String templateId, String name, String description, String content, String type) {
        this.templateId = templateId;
        this.name = name;
        this.description = description;
        this.content = content;
        this.type = type;
    }

    @Override
    @JsonProperty(value="templateId")
    public String getTemplateId() {
        return this.templateId;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public final ImmutableTemplateMutator withTemplateId(String value) {
        String newValue = Objects.requireNonNull(value, "templateId");
        if (this.templateId.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateMutator(newValue, this.name, this.description, this.content, this.type);
    }

    public final ImmutableTemplateMutator withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateMutator(this.templateId, newValue, this.description, this.content, this.type);
    }

    public final ImmutableTemplateMutator withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateMutator(this.templateId, this.name, newValue, this.content, this.type);
    }

    public final ImmutableTemplateMutator withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateMutator(this.templateId, this.name, this.description, newValue, this.type);
    }

    public final ImmutableTemplateMutator withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateMutator(this.templateId, this.name, this.description, this.content, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTemplateMutator && this.equalTo((ImmutableTemplateMutator)another);
    }

    private boolean equalTo(ImmutableTemplateMutator another) {
        return this.templateId.equals(another.templateId) && this.name.equals(another.name) && this.description.equals(another.description) && this.content.equals(another.content) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.templateId.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TemplateMutator").omitNullValues().add("templateId", (Object)this.templateId).add("name", (Object)this.name).add("description", (Object)this.description).add("content", (Object)this.content).add("type", (Object)this.type).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTemplateMutator fromJson(Json json) {
        Builder builder = ImmutableTemplateMutator.builder();
        if (json.templateId != null) {
            builder.templateId(json.templateId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableTemplateMutator copyOf(UpdateBuilder.TemplateMutator instance) {
        if (instance instanceof ImmutableTemplateMutator) {
            return (ImmutableTemplateMutator)instance;
        }
        return ImmutableTemplateMutator.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UpdateBuilder.TemplateMutator", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEMPLATE_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private static final long INIT_BIT_CONTENT = 8L;
        private static final long INIT_BIT_TYPE = 16L;
        private long initBits = 31L;
        @Nullable
        private String templateId;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private String content;
        @Nullable
        private String type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UpdateBuilder.TemplateMutator instance) {
            Objects.requireNonNull(instance, "instance");
            this.templateId(instance.getTemplateId());
            this.name(instance.getName());
            this.description(instance.getDescription());
            this.content(instance.getContent());
            this.type(instance.getType());
            return this;
        }

        @JsonProperty(value="templateId")
        @CanIgnoreReturnValue
        public final Builder templateId(String templateId) {
            this.templateId = Objects.requireNonNull(templateId, "templateId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableTemplateMutator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTemplateMutator(this.templateId, this.name, this.description, this.content, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("templateId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build TemplateMutator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UpdateBuilder.TemplateMutator", generator="Immutables")
    static final class Json
    implements UpdateBuilder.TemplateMutator {
        @Nullable
        String templateId;
        @Nullable
        String name;
        @Nullable
        String description;
        @Nullable
        String content;
        @Nullable
        String type;

        Json() {
        }

        @JsonProperty(value="templateId")
        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getTemplateId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }
    }
}

