/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.PageReleaseItem", generator="Immutables")
@Immutable
public final class ImmutablePageReleaseItem
implements StencilClient.PageReleaseItem {
    private final String id;
    private final String hash;
    private final String locale;
    private final String h1;

    private ImmutablePageReleaseItem(String id, String hash, String locale, String h1) {
        this.id = id;
        this.hash = hash;
        this.locale = locale;
        this.h1 = h1;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @Override
    @JsonProperty(value="h1")
    public String getH1() {
        return this.h1;
    }

    public final ImmutablePageReleaseItem withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePageReleaseItem(newValue, this.hash, this.locale, this.h1);
    }

    public final ImmutablePageReleaseItem withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutablePageReleaseItem(this.id, newValue, this.locale, this.h1);
    }

    public final ImmutablePageReleaseItem withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutablePageReleaseItem(this.id, this.hash, newValue, this.h1);
    }

    public final ImmutablePageReleaseItem withH1(String value) {
        String newValue = Objects.requireNonNull(value, "h1");
        if (this.h1.equals(newValue)) {
            return this;
        }
        return new ImmutablePageReleaseItem(this.id, this.hash, this.locale, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageReleaseItem && this.equalTo((ImmutablePageReleaseItem)another);
    }

    private boolean equalTo(ImmutablePageReleaseItem another) {
        return this.id.equals(another.id) && this.hash.equals(another.hash) && this.locale.equals(another.locale) && this.h1.equals(another.h1);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.h1.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PageReleaseItem").omitNullValues().add("id", (Object)this.id).add("hash", (Object)this.hash).add("locale", (Object)this.locale).add("h1", (Object)this.h1).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePageReleaseItem fromJson(Json json) {
        Builder builder = ImmutablePageReleaseItem.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        if (json.h1 != null) {
            builder.h1(json.h1);
        }
        return builder.build();
    }

    public static ImmutablePageReleaseItem copyOf(StencilClient.PageReleaseItem instance) {
        if (instance instanceof ImmutablePageReleaseItem) {
            return (ImmutablePageReleaseItem)instance;
        }
        return ImmutablePageReleaseItem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.PageReleaseItem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long INIT_BIT_LOCALE = 4L;
        private static final long INIT_BIT_H1 = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String hash;
        @Nullable
        private String locale;
        @Nullable
        private String h1;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.ReleaseItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.PageReleaseItem instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            StencilClient.ReleaseItem instance;
            if (object instanceof StencilClient.ReleaseItem) {
                instance = (StencilClient.ReleaseItem)object;
                this.hash(instance.getHash());
                this.id(instance.getId());
            }
            if (object instanceof StencilClient.PageReleaseItem) {
                instance = (StencilClient.PageReleaseItem)object;
                this.locale(instance.getLocale());
                this.h1(instance.getH1());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="locale")
        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="h1")
        @CanIgnoreReturnValue
        public final Builder h1(String h1) {
            this.h1 = Objects.requireNonNull(h1, "h1");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutablePageReleaseItem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePageReleaseItem(this.id, this.hash, this.locale, this.h1);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("h1");
            }
            return "Cannot build PageReleaseItem, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.PageReleaseItem", generator="Immutables")
    static final class Json
    implements StencilClient.PageReleaseItem {
        @Nullable
        String id;
        @Nullable
        String hash;
        @Nullable
        String locale;
        @Nullable
        String h1;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @JsonProperty(value="h1")
        public void setH1(String h1) {
            this.h1 = h1;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getH1() {
            throw new UnsupportedOperationException();
        }
    }
}

