/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.CreateBuilder;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateBuilder.CreateLink", generator="Immutables")
@Immutable
public final class ImmutableCreateLink
implements CreateBuilder.CreateLink {
    private final String value;
    private final String type;
    private final ImmutableList<String> articles;
    private final ImmutableList<StencilClient.LocaleLabel> labels;

    private ImmutableCreateLink(String value, String type, ImmutableList<String> articles, ImmutableList<StencilClient.LocaleLabel> labels) {
        this.value = value;
        this.type = type;
        this.articles = articles;
        this.labels = labels;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="articles")
    public ImmutableList<String> getArticles() {
        return this.articles;
    }

    @JsonProperty(value="labels")
    public ImmutableList<StencilClient.LocaleLabel> getLabels() {
        return this.labels;
    }

    public final ImmutableCreateLink withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateLink(newValue, this.type, this.articles, this.labels);
    }

    public final ImmutableCreateLink withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateLink(this.value, newValue, this.articles, this.labels);
    }

    public final ImmutableCreateLink withArticles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateLink(this.value, this.type, (ImmutableList<String>)newValue, this.labels);
    }

    public final ImmutableCreateLink withArticles(Iterable<String> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateLink(this.value, this.type, (ImmutableList<String>)newValue, this.labels);
    }

    public final ImmutableCreateLink withLabels(StencilClient.LocaleLabel ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateLink(this.value, this.type, this.articles, (ImmutableList<StencilClient.LocaleLabel>)newValue);
    }

    public final ImmutableCreateLink withLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
        if (this.labels == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateLink(this.value, this.type, this.articles, (ImmutableList<StencilClient.LocaleLabel>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateLink && this.equalTo((ImmutableCreateLink)another);
    }

    private boolean equalTo(ImmutableCreateLink another) {
        return this.value.equals(another.value) && this.type.equals(another.type) && this.articles.equals(another.articles) && this.labels.equals(another.labels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.articles.hashCode();
        h += (h << 5) + this.labels.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateLink").omitNullValues().add("value", (Object)this.value).add("type", (Object)this.type).add("articles", this.articles).add("labels", this.labels).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreateLink fromJson(Json json) {
        Builder builder = ImmutableCreateLink.builder();
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        if (json.labels != null) {
            builder.addAllLabels(json.labels);
        }
        return builder.build();
    }

    public static ImmutableCreateLink copyOf(CreateBuilder.CreateLink instance) {
        if (instance instanceof ImmutableCreateLink) {
            return (ImmutableCreateLink)instance;
        }
        return ImmutableCreateLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateBuilder.CreateLink", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String value;
        @Nullable
        private String type;
        private ImmutableList.Builder<String> articles = ImmutableList.builder();
        private ImmutableList.Builder<StencilClient.LocaleLabel> labels = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateBuilder.CreateLink instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            this.type(instance.getType());
            this.addAllArticles(instance.getArticles());
            this.addAllLabels(instance.getLabels());
            return this;
        }

        @JsonProperty(value="value")
        @CanIgnoreReturnValue
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String element) {
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String ... elements) {
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(Iterable<String> elements) {
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<String> elements) {
            this.articles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel element) {
            this.labels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLabels(StencilClient.LocaleLabel ... elements) {
            this.labels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="labels")
        @CanIgnoreReturnValue
        public final Builder labels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            this.labels = ImmutableList.builder();
            return this.addAllLabels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
            this.labels.addAll(elements);
            return this;
        }

        public ImmutableCreateLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateLink(this.value, this.type, (ImmutableList<String>)this.articles.build(), (ImmutableList<StencilClient.LocaleLabel>)this.labels.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build CreateLink, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CreateBuilder.CreateLink", generator="Immutables")
    static final class Json
    implements CreateBuilder.CreateLink {
        @Nullable
        String value;
        @Nullable
        String type;
        @Nullable
        List<String> articles = ImmutableList.of();
        @Nullable
        List<StencilClient.LocaleLabel> labels = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="articles")
        public void setArticles(List<String> articles) {
            this.articles = articles;
        }

        @JsonProperty(value="labels")
        public void setLabels(List<StencilClient.LocaleLabel> labels) {
            this.labels = labels;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getArticles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<StencilClient.LocaleLabel> getLabels() {
            throw new UnsupportedOperationException();
        }
    }
}

