package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.Page}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePage.builder()}.
 */
@Generated(from = "StencilClient.Page", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePage implements StencilClient.Page {
  private final String article;
  private final String locale;
  private final String content;

  private ImmutablePage(String article, String locale, String content) {
    this.article = article;
    this.locale = locale;
    this.content = content;
  }

  /**
   * @return The value of the {@code article} attribute
   */
  @JsonProperty("article")
  @Override
  public String getArticle() {
    return article;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty("locale")
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty("content")
  @Override
  public String getContent() {
    return content;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Page#getArticle() article} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for article
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePage withArticle(String value) {
    String newValue = Objects.requireNonNull(value, "article");
    if (this.article.equals(newValue)) return this;
    return new ImmutablePage(newValue, this.locale, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Page#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePage withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutablePage(this.article, newValue, this.content);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Page#getContent() content} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for content
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePage withContent(String value) {
    String newValue = Objects.requireNonNull(value, "content");
    if (this.content.equals(newValue)) return this;
    return new ImmutablePage(this.article, this.locale, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePage
        && equalTo((ImmutablePage) another);
  }

  private boolean equalTo(ImmutablePage another) {
    return article.equals(another.article)
        && locale.equals(another.locale)
        && content.equals(another.content);
  }

  /**
   * Computes a hash code from attributes: {@code article}, {@code locale}, {@code content}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + article.hashCode();
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + content.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Page} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Page")
        .omitNullValues()
        .add("article", article)
        .add("locale", locale)
        .add("content", content)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.Page", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.Page {
    @Nullable String article;
    @Nullable String locale;
    @Nullable String content;
    @JsonProperty("article")
    public void setArticle(String article) {
      this.article = article;
    }
    @JsonProperty("locale")
    public void setLocale(String locale) {
      this.locale = locale;
    }
    @JsonProperty("content")
    public void setContent(String content) {
      this.content = content;
    }
    @Override
    public String getArticle() { throw new UnsupportedOperationException(); }
    @Override
    public String getLocale() { throw new UnsupportedOperationException(); }
    @Override
    public String getContent() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePage fromJson(Json json) {
    ImmutablePage.Builder builder = ImmutablePage.builder();
    if (json.article != null) {
      builder.article(json.article);
    }
    if (json.locale != null) {
      builder.locale(json.locale);
    }
    if (json.content != null) {
      builder.content(json.content);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.Page} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Page instance
   */
  public static ImmutablePage copyOf(StencilClient.Page instance) {
    if (instance instanceof ImmutablePage) {
      return (ImmutablePage) instance;
    }
    return ImmutablePage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePage ImmutablePage}.
   * <pre>
   * ImmutablePage.builder()
   *    .article(String) // required {@link StencilClient.Page#getArticle() article}
   *    .locale(String) // required {@link StencilClient.Page#getLocale() locale}
   *    .content(String) // required {@link StencilClient.Page#getContent() content}
   *    .build();
   * </pre>
   * @return A new ImmutablePage builder
   */
  public static ImmutablePage.Builder builder() {
    return new ImmutablePage.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePage ImmutablePage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.Page", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ARTICLE = 0x1L;
    private static final long INIT_BIT_LOCALE = 0x2L;
    private static final long INIT_BIT_CONTENT = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String article;
    private @Nullable String locale;
    private @Nullable String content;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Page} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.Page instance) {
      Objects.requireNonNull(instance, "instance");
      article(instance.getArticle());
      locale(instance.getLocale());
      content(instance.getContent());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Page#getArticle() article} attribute.
     * @param article The value for article 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("article")
    public final Builder article(String article) {
      this.article = Objects.requireNonNull(article, "article");
      initBits &= ~INIT_BIT_ARTICLE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Page#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locale")
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Page#getContent() content} attribute.
     * @param content The value for content 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("content")
    public final Builder content(String content) {
      this.content = Objects.requireNonNull(content, "content");
      initBits &= ~INIT_BIT_CONTENT;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePage ImmutablePage}.
     * @return An immutable instance of Page
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePage build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePage(article, locale, content);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ARTICLE) != 0) attributes.add("article");
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      if ((initBits & INIT_BIT_CONTENT) != 0) attributes.add("content");
      return "Cannot build Page, some of required attributes are not set " + attributes;
    }
  }
}
