package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateBuilder.WorkflowMutator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWorkflowMutator.builder()}.
 */
@Generated(from = "UpdateBuilder.WorkflowMutator", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWorkflowMutator implements UpdateBuilder.WorkflowMutator {
  private final String workflowId;
  private final String value;
  private final @Nullable ImmutableList<StencilClient.LocaleLabel> labels;
  private final @Nullable ImmutableList<String> articles;
  private final @Nullable Boolean devMode;

  private ImmutableWorkflowMutator(
      String workflowId,
      String value,
      @Nullable ImmutableList<StencilClient.LocaleLabel> labels,
      @Nullable ImmutableList<String> articles,
      @Nullable Boolean devMode) {
    this.workflowId = workflowId;
    this.value = value;
    this.labels = labels;
    this.articles = articles;
    this.devMode = devMode;
  }

  /**
   * @return The value of the {@code workflowId} attribute
   */
  @JsonProperty("workflowId")
  @Override
  public String getWorkflowId() {
    return workflowId;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @Override
  public @Nullable ImmutableList<StencilClient.LocaleLabel> getLabels() {
    return labels;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public @Nullable ImmutableList<String> getArticles() {
    return articles;
  }

  /**
   * @return The value of the {@code devMode} attribute
   */
  @JsonProperty("devMode")
  @Override
  public @Nullable Boolean getDevMode() {
    return devMode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.WorkflowMutator#getWorkflowId() workflowId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for workflowId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowMutator withWorkflowId(String value) {
    String newValue = Objects.requireNonNull(value, "workflowId");
    if (this.workflowId.equals(newValue)) return this;
    return new ImmutableWorkflowMutator(newValue, this.value, this.labels, this.articles, this.devMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.WorkflowMutator#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowMutator withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableWorkflowMutator(this.workflowId, newValue, this.labels, this.articles, this.devMode);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateBuilder.WorkflowMutator#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowMutator withLabels(@Nullable StencilClient.LocaleLabel... elements) {
    if (elements == null) {
      return new ImmutableWorkflowMutator(this.workflowId, this.value, null, this.articles, this.devMode);
    }
    @Nullable ImmutableList<StencilClient.LocaleLabel> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableWorkflowMutator(this.workflowId, this.value, newValue, this.articles, this.devMode);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateBuilder.WorkflowMutator#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowMutator withLabels(@Nullable Iterable<? extends StencilClient.LocaleLabel> elements) {
    if (this.labels == elements) return this;
    @Nullable ImmutableList<StencilClient.LocaleLabel> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableWorkflowMutator(this.workflowId, this.value, newValue, this.articles, this.devMode);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateBuilder.WorkflowMutator#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowMutator withArticles(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableWorkflowMutator(this.workflowId, this.value, this.labels, null, this.devMode);
    }
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableWorkflowMutator(this.workflowId, this.value, this.labels, newValue, this.devMode);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UpdateBuilder.WorkflowMutator#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflowMutator withArticles(@Nullable Iterable<String> elements) {
    if (this.articles == elements) return this;
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableWorkflowMutator(this.workflowId, this.value, this.labels, newValue, this.devMode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateBuilder.WorkflowMutator#getDevMode() devMode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for devMode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflowMutator withDevMode(@Nullable Boolean value) {
    if (Objects.equals(this.devMode, value)) return this;
    return new ImmutableWorkflowMutator(this.workflowId, this.value, this.labels, this.articles, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWorkflowMutator} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWorkflowMutator
        && equalTo((ImmutableWorkflowMutator) another);
  }

  private boolean equalTo(ImmutableWorkflowMutator another) {
    return workflowId.equals(another.workflowId)
        && value.equals(another.value)
        && Objects.equals(labels, another.labels)
        && Objects.equals(articles, another.articles)
        && Objects.equals(devMode, another.devMode);
  }

  /**
   * Computes a hash code from attributes: {@code workflowId}, {@code value}, {@code labels}, {@code articles}, {@code devMode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + workflowId.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + Objects.hashCode(labels);
    h += (h << 5) + Objects.hashCode(articles);
    h += (h << 5) + Objects.hashCode(devMode);
    return h;
  }

  /**
   * Prints the immutable value {@code WorkflowMutator} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("WorkflowMutator")
        .omitNullValues()
        .add("workflowId", workflowId)
        .add("value", value)
        .add("labels", labels)
        .add("articles", articles)
        .add("devMode", devMode)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UpdateBuilder.WorkflowMutator", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UpdateBuilder.WorkflowMutator {
    @Nullable String workflowId;
    @Nullable String value;
    @Nullable List<StencilClient.LocaleLabel> labels = null;
    @Nullable List<String> articles = null;
    @Nullable Boolean devMode;
    @JsonProperty("workflowId")
    public void setWorkflowId(String workflowId) {
      this.workflowId = workflowId;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("labels")
    public void setLabels(@Nullable List<StencilClient.LocaleLabel> labels) {
      this.labels = labels;
    }
    @JsonProperty("articles")
    public void setArticles(@Nullable List<String> articles) {
      this.articles = articles;
    }
    @JsonProperty("devMode")
    public void setDevMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
    }
    @Override
    public String getWorkflowId() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.LocaleLabel> getLabels() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getArticles() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDevMode() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableWorkflowMutator fromJson(Json json) {
    ImmutableWorkflowMutator.Builder builder = ImmutableWorkflowMutator.builder();
    if (json.workflowId != null) {
      builder.workflowId(json.workflowId);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.labels != null) {
      builder.addAllLabels(json.labels);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    if (json.devMode != null) {
      builder.devMode(json.devMode);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UpdateBuilder.WorkflowMutator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WorkflowMutator instance
   */
  public static ImmutableWorkflowMutator copyOf(UpdateBuilder.WorkflowMutator instance) {
    if (instance instanceof ImmutableWorkflowMutator) {
      return (ImmutableWorkflowMutator) instance;
    }
    return ImmutableWorkflowMutator.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWorkflowMutator ImmutableWorkflowMutator}.
   * <pre>
   * ImmutableWorkflowMutator.builder()
   *    .workflowId(String) // required {@link UpdateBuilder.WorkflowMutator#getWorkflowId() workflowId}
   *    .value(String) // required {@link UpdateBuilder.WorkflowMutator#getValue() value}
   *    .labels(List&amp;lt;io.thestencil.client.api.StencilClient.LocaleLabel&amp;gt; | null) // nullable {@link UpdateBuilder.WorkflowMutator#getLabels() labels}
   *    .articles(List&amp;lt;String&amp;gt; | null) // nullable {@link UpdateBuilder.WorkflowMutator#getArticles() articles}
   *    .devMode(Boolean | null) // nullable {@link UpdateBuilder.WorkflowMutator#getDevMode() devMode}
   *    .build();
   * </pre>
   * @return A new ImmutableWorkflowMutator builder
   */
  public static ImmutableWorkflowMutator.Builder builder() {
    return new ImmutableWorkflowMutator.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWorkflowMutator ImmutableWorkflowMutator}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateBuilder.WorkflowMutator", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_WORKFLOW_ID = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String workflowId;
    private @Nullable String value;
    private ImmutableList.Builder<StencilClient.LocaleLabel> labels = null;
    private ImmutableList.Builder<String> articles = null;
    private @Nullable Boolean devMode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WorkflowMutator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateBuilder.WorkflowMutator instance) {
      Objects.requireNonNull(instance, "instance");
      workflowId(instance.getWorkflowId());
      value(instance.getValue());
      @Nullable List<StencilClient.LocaleLabel> labelsValue = instance.getLabels();
      if (labelsValue != null) {
        addAllLabels(labelsValue);
      }
      @Nullable List<String> articlesValue = instance.getArticles();
      if (articlesValue != null) {
        addAllArticles(articlesValue);
      }
      @Nullable Boolean devModeValue = instance.getDevMode();
      if (devModeValue != null) {
        devMode(devModeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.WorkflowMutator#getWorkflowId() workflowId} attribute.
     * @param workflowId The value for workflowId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("workflowId")
    public final Builder workflowId(String workflowId) {
      this.workflowId = Objects.requireNonNull(workflowId, "workflowId");
      initBits &= ~INIT_BIT_WORKFLOW_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.WorkflowMutator#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Adds one element to {@link UpdateBuilder.WorkflowMutator#getLabels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel element) {
      if (this.labels == null) {
        this.labels = ImmutableList.builder();
      }
      this.labels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UpdateBuilder.WorkflowMutator#getLabels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel... elements) {
      if (this.labels == null) {
        this.labels = ImmutableList.builder();
      }
      this.labels.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateBuilder.WorkflowMutator#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    public final Builder labels(@Nullable Iterable<? extends StencilClient.LocaleLabel> elements) {
      if (elements == null) {
        this.labels = null;
        return this;
      }
      this.labels = ImmutableList.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link UpdateBuilder.WorkflowMutator#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      Objects.requireNonNull(elements, "labels element");
      if (this.labels == null) {
        this.labels = ImmutableList.builder();
      }
      this.labels.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link UpdateBuilder.WorkflowMutator#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String element) {
      if (this.articles == null) {
        this.articles = ImmutableList.builder();
      }
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link UpdateBuilder.WorkflowMutator#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String... elements) {
      if (this.articles == null) {
        this.articles = ImmutableList.builder();
      }
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UpdateBuilder.WorkflowMutator#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.articles = null;
        return this;
      }
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link UpdateBuilder.WorkflowMutator#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<String> elements) {
      Objects.requireNonNull(elements, "articles element");
      if (this.articles == null) {
        this.articles = ImmutableList.builder();
      }
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateBuilder.WorkflowMutator#getDevMode() devMode} attribute.
     * @param devMode The value for devMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("devMode")
    public final Builder devMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWorkflowMutator ImmutableWorkflowMutator}.
     * @return An immutable instance of WorkflowMutator
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWorkflowMutator build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWorkflowMutator(
          workflowId,
          value,
          labels == null ? null : labels.build(),
          articles == null ? null : articles.build(),
          devMode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_WORKFLOW_ID) != 0) attributes.add("workflowId");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build WorkflowMutator, some of required attributes are not set " + attributes;
    }
  }
}
