package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.Workflow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWorkflow.builder()}.
 */
@Generated(from = "StencilClient.Workflow", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWorkflow implements StencilClient.Workflow {
  private final String value;
  private final @Nullable Boolean devMode;
  private final ImmutableList<String> articles;
  private final ImmutableList<StencilClient.LocaleLabel> labels;

  private ImmutableWorkflow(
      String value,
      @Nullable Boolean devMode,
      ImmutableList<String> articles,
      ImmutableList<StencilClient.LocaleLabel> labels) {
    this.value = value;
    this.devMode = devMode;
    this.articles = articles;
    this.labels = labels;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code devMode} attribute
   */
  @JsonProperty("devMode")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public @Nullable Boolean getDevMode() {
    return devMode;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<String> getArticles() {
    return articles;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @Override
  public ImmutableList<StencilClient.LocaleLabel> getLabels() {
    return labels;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Workflow#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflow withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableWorkflow(newValue, this.devMode, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Workflow#getDevMode() devMode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for devMode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWorkflow withDevMode(@Nullable Boolean value) {
    if (Objects.equals(this.devMode, value)) return this;
    return new ImmutableWorkflow(this.value, value, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Workflow#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflow withArticles(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflow(this.value, this.devMode, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Workflow#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflow withArticles(Iterable<String> elements) {
    if (this.articles == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflow(this.value, this.devMode, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Workflow#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflow withLabels(StencilClient.LocaleLabel... elements) {
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflow(this.value, this.devMode, this.articles, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.Workflow#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWorkflow withLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
    if (this.labels == elements) return this;
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableWorkflow(this.value, this.devMode, this.articles, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWorkflow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWorkflow
        && equalTo((ImmutableWorkflow) another);
  }

  private boolean equalTo(ImmutableWorkflow another) {
    return value.equals(another.value)
        && Objects.equals(devMode, another.devMode)
        && articles.equals(another.articles)
        && labels.equals(another.labels);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code devMode}, {@code articles}, {@code labels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + Objects.hashCode(devMode);
    h += (h << 5) + articles.hashCode();
    h += (h << 5) + labels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Workflow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Workflow")
        .omitNullValues()
        .add("value", value)
        .add("devMode", devMode)
        .add("articles", articles)
        .add("labels", labels)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.Workflow", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.Workflow {
    @Nullable String value;
    @Nullable Boolean devMode;
    @Nullable List<String> articles = ImmutableList.of();
    @Nullable List<StencilClient.LocaleLabel> labels = ImmutableList.of();
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("devMode")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public void setDevMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
    }
    @JsonProperty("articles")
    public void setArticles(List<String> articles) {
      this.articles = articles;
    }
    @JsonProperty("labels")
    public void setLabels(List<StencilClient.LocaleLabel> labels) {
      this.labels = labels;
    }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDevMode() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getArticles() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.LocaleLabel> getLabels() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableWorkflow fromJson(Json json) {
    ImmutableWorkflow.Builder builder = ImmutableWorkflow.builder();
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.devMode != null) {
      builder.devMode(json.devMode);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    if (json.labels != null) {
      builder.addAllLabels(json.labels);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.Workflow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Workflow instance
   */
  public static ImmutableWorkflow copyOf(StencilClient.Workflow instance) {
    if (instance instanceof ImmutableWorkflow) {
      return (ImmutableWorkflow) instance;
    }
    return ImmutableWorkflow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWorkflow ImmutableWorkflow}.
   * <pre>
   * ImmutableWorkflow.builder()
   *    .value(String) // required {@link StencilClient.Workflow#getValue() value}
   *    .devMode(Boolean | null) // nullable {@link StencilClient.Workflow#getDevMode() devMode}
   *    .addArticles|addAllArticles(String) // {@link StencilClient.Workflow#getArticles() articles} elements
   *    .addLabels|addAllLabels(io.thestencil.client.api.StencilClient.LocaleLabel) // {@link StencilClient.Workflow#getLabels() labels} elements
   *    .build();
   * </pre>
   * @return A new ImmutableWorkflow builder
   */
  public static ImmutableWorkflow.Builder builder() {
    return new ImmutableWorkflow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWorkflow ImmutableWorkflow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.Workflow", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String value;
    private @Nullable Boolean devMode;
    private ImmutableList.Builder<String> articles = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.LocaleLabel> labels = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Workflow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.Workflow instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      @Nullable Boolean devModeValue = instance.getDevMode();
      if (devModeValue != null) {
        devMode(devModeValue);
      }
      addAllArticles(instance.getArticles());
      addAllLabels(instance.getLabels());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Workflow#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Workflow#getDevMode() devMode} attribute.
     * @param devMode The value for devMode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("devMode")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public final Builder devMode(@Nullable Boolean devMode) {
      this.devMode = devMode;
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Workflow#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Workflow#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Workflow#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<String> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Workflow#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<String> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.Workflow#getLabels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel element) {
      this.labels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.Workflow#getLabels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel... elements) {
      this.labels.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.Workflow#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    public final Builder labels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels = ImmutableList.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link StencilClient.Workflow#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableWorkflow ImmutableWorkflow}.
     * @return An immutable instance of Workflow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWorkflow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableWorkflow(value, devMode, articles.build(), labels.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build Workflow, some of required attributes are not set " + attributes;
    }
  }
}
