package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.LocaleReleaseItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLocaleReleaseItem.builder()}.
 */
@Generated(from = "StencilClient.LocaleReleaseItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLocaleReleaseItem
    implements StencilClient.LocaleReleaseItem {
  private final String id;
  private final String hash;
  private final String value;

  private ImmutableLocaleReleaseItem(String id, String hash, String value) {
    this.id = id;
    this.hash = hash;
    this.value = value;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.LocaleReleaseItem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocaleReleaseItem withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableLocaleReleaseItem(newValue, this.hash, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.LocaleReleaseItem#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocaleReleaseItem withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableLocaleReleaseItem(this.id, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.LocaleReleaseItem#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocaleReleaseItem withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableLocaleReleaseItem(this.id, this.hash, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLocaleReleaseItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLocaleReleaseItem
        && equalTo((ImmutableLocaleReleaseItem) another);
  }

  private boolean equalTo(ImmutableLocaleReleaseItem another) {
    return id.equals(another.id)
        && hash.equals(another.hash)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code hash}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LocaleReleaseItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LocaleReleaseItem")
        .omitNullValues()
        .add("id", id)
        .add("hash", hash)
        .add("value", value)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.LocaleReleaseItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.LocaleReleaseItem {
    @Nullable String id;
    @Nullable String hash;
    @Nullable String value;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLocaleReleaseItem fromJson(Json json) {
    ImmutableLocaleReleaseItem.Builder builder = ImmutableLocaleReleaseItem.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.LocaleReleaseItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LocaleReleaseItem instance
   */
  public static ImmutableLocaleReleaseItem copyOf(StencilClient.LocaleReleaseItem instance) {
    if (instance instanceof ImmutableLocaleReleaseItem) {
      return (ImmutableLocaleReleaseItem) instance;
    }
    return ImmutableLocaleReleaseItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLocaleReleaseItem ImmutableLocaleReleaseItem}.
   * <pre>
   * ImmutableLocaleReleaseItem.builder()
   *    .id(String) // required {@link StencilClient.LocaleReleaseItem#getId() id}
   *    .hash(String) // required {@link StencilClient.LocaleReleaseItem#getHash() hash}
   *    .value(String) // required {@link StencilClient.LocaleReleaseItem#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableLocaleReleaseItem builder
   */
  public static ImmutableLocaleReleaseItem.Builder builder() {
    return new ImmutableLocaleReleaseItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLocaleReleaseItem ImmutableLocaleReleaseItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.LocaleReleaseItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_HASH = 0x2L;
    private static final long INIT_BIT_VALUE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String hash;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.ReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.ReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.LocaleReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.LocaleReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StencilClient.ReleaseItem) {
        StencilClient.ReleaseItem instance = (StencilClient.ReleaseItem) object;
        hash(instance.getHash());
        id(instance.getId());
      }
      if (object instanceof StencilClient.LocaleReleaseItem) {
        StencilClient.LocaleReleaseItem instance = (StencilClient.LocaleReleaseItem) object;
        value(instance.getValue());
      }
    }

    /**
     * Initializes the value for the {@link StencilClient.LocaleReleaseItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.LocaleReleaseItem#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.LocaleReleaseItem#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLocaleReleaseItem ImmutableLocaleReleaseItem}.
     * @return An immutable instance of LocaleReleaseItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLocaleReleaseItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLocaleReleaseItem(id, hash, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build LocaleReleaseItem, some of required attributes are not set " + attributes;
    }
  }
}
