package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.LocaleLabel}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLocaleLabel.builder()}.
 */
@Generated(from = "StencilClient.LocaleLabel", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLocaleLabel implements StencilClient.LocaleLabel {
  private final String locale;
  private final String labelValue;

  private ImmutableLocaleLabel(String locale, String labelValue) {
    this.locale = locale;
    this.labelValue = labelValue;
  }

  /**
   * @return The value of the {@code locale} attribute
   */
  @JsonProperty("locale")
  @Override
  public String getLocale() {
    return locale;
  }

  /**
   * @return The value of the {@code labelValue} attribute
   */
  @JsonProperty("labelValue")
  @Override
  public String getLabelValue() {
    return labelValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.LocaleLabel#getLocale() locale} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locale
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocaleLabel withLocale(String value) {
    String newValue = Objects.requireNonNull(value, "locale");
    if (this.locale.equals(newValue)) return this;
    return new ImmutableLocaleLabel(newValue, this.labelValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.LocaleLabel#getLabelValue() labelValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for labelValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLocaleLabel withLabelValue(String value) {
    String newValue = Objects.requireNonNull(value, "labelValue");
    if (this.labelValue.equals(newValue)) return this;
    return new ImmutableLocaleLabel(this.locale, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLocaleLabel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLocaleLabel
        && equalTo((ImmutableLocaleLabel) another);
  }

  private boolean equalTo(ImmutableLocaleLabel another) {
    return locale.equals(another.locale)
        && labelValue.equals(another.labelValue);
  }

  /**
   * Computes a hash code from attributes: {@code locale}, {@code labelValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + locale.hashCode();
    h += (h << 5) + labelValue.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LocaleLabel} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LocaleLabel")
        .omitNullValues()
        .add("locale", locale)
        .add("labelValue", labelValue)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.LocaleLabel", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.LocaleLabel {
    @Nullable String locale;
    @Nullable String labelValue;
    @JsonProperty("locale")
    public void setLocale(String locale) {
      this.locale = locale;
    }
    @JsonProperty("labelValue")
    public void setLabelValue(String labelValue) {
      this.labelValue = labelValue;
    }
    @Override
    public String getLocale() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabelValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLocaleLabel fromJson(Json json) {
    ImmutableLocaleLabel.Builder builder = ImmutableLocaleLabel.builder();
    if (json.locale != null) {
      builder.locale(json.locale);
    }
    if (json.labelValue != null) {
      builder.labelValue(json.labelValue);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.LocaleLabel} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LocaleLabel instance
   */
  public static ImmutableLocaleLabel copyOf(StencilClient.LocaleLabel instance) {
    if (instance instanceof ImmutableLocaleLabel) {
      return (ImmutableLocaleLabel) instance;
    }
    return ImmutableLocaleLabel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLocaleLabel ImmutableLocaleLabel}.
   * <pre>
   * ImmutableLocaleLabel.builder()
   *    .locale(String) // required {@link StencilClient.LocaleLabel#getLocale() locale}
   *    .labelValue(String) // required {@link StencilClient.LocaleLabel#getLabelValue() labelValue}
   *    .build();
   * </pre>
   * @return A new ImmutableLocaleLabel builder
   */
  public static ImmutableLocaleLabel.Builder builder() {
    return new ImmutableLocaleLabel.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLocaleLabel ImmutableLocaleLabel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.LocaleLabel", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LOCALE = 0x1L;
    private static final long INIT_BIT_LABEL_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String locale;
    private @Nullable String labelValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LocaleLabel} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.LocaleLabel instance) {
      Objects.requireNonNull(instance, "instance");
      locale(instance.getLocale());
      labelValue(instance.getLabelValue());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.LocaleLabel#getLocale() locale} attribute.
     * @param locale The value for locale 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("locale")
    public final Builder locale(String locale) {
      this.locale = Objects.requireNonNull(locale, "locale");
      initBits &= ~INIT_BIT_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.LocaleLabel#getLabelValue() labelValue} attribute.
     * @param labelValue The value for labelValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labelValue")
    public final Builder labelValue(String labelValue) {
      this.labelValue = Objects.requireNonNull(labelValue, "labelValue");
      initBits &= ~INIT_BIT_LABEL_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLocaleLabel ImmutableLocaleLabel}.
     * @return An immutable instance of LocaleLabel
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLocaleLabel build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLocaleLabel(locale, labelValue);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LOCALE) != 0) attributes.add("locale");
      if ((initBits & INIT_BIT_LABEL_VALUE) != 0) attributes.add("labelValue");
      return "Cannot build LocaleLabel, some of required attributes are not set " + attributes;
    }
  }
}
