package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.LinkReleaseItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLinkReleaseItem.builder()}.
 */
@Generated(from = "StencilClient.LinkReleaseItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLinkReleaseItem implements StencilClient.LinkReleaseItem {
  private final String id;
  private final String hash;
  private final String value;
  private final String contentType;
  private final ImmutableList<String> articles;
  private final ImmutableList<StencilClient.LocaleLabel> labels;

  private ImmutableLinkReleaseItem(
      String id,
      String hash,
      String value,
      String contentType,
      ImmutableList<String> articles,
      ImmutableList<StencilClient.LocaleLabel> labels) {
    this.id = id;
    this.hash = hash;
    this.value = value;
    this.contentType = contentType;
    this.articles = articles;
    this.labels = labels;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String getHash() {
    return hash;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code contentType} attribute
   */
  @JsonProperty("contentType")
  @Override
  public String getContentType() {
    return contentType;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<String> getArticles() {
    return articles;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @Override
  public ImmutableList<StencilClient.LocaleLabel> getLabels() {
    return labels;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.LinkReleaseItem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkReleaseItem withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableLinkReleaseItem(newValue, this.hash, this.value, this.contentType, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.LinkReleaseItem#getHash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkReleaseItem withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableLinkReleaseItem(this.id, newValue, this.value, this.contentType, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.LinkReleaseItem#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkReleaseItem withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableLinkReleaseItem(this.id, this.hash, newValue, this.contentType, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.LinkReleaseItem#getContentType() contentType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLinkReleaseItem withContentType(String value) {
    String newValue = Objects.requireNonNull(value, "contentType");
    if (this.contentType.equals(newValue)) return this;
    return new ImmutableLinkReleaseItem(this.id, this.hash, this.value, newValue, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.LinkReleaseItem#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLinkReleaseItem withArticles(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLinkReleaseItem(this.id, this.hash, this.value, this.contentType, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.LinkReleaseItem#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLinkReleaseItem withArticles(Iterable<String> elements) {
    if (this.articles == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLinkReleaseItem(this.id, this.hash, this.value, this.contentType, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.LinkReleaseItem#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLinkReleaseItem withLabels(StencilClient.LocaleLabel... elements) {
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLinkReleaseItem(this.id, this.hash, this.value, this.contentType, this.articles, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StencilClient.LinkReleaseItem#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLinkReleaseItem withLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
    if (this.labels == elements) return this;
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLinkReleaseItem(this.id, this.hash, this.value, this.contentType, this.articles, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLinkReleaseItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLinkReleaseItem
        && equalTo((ImmutableLinkReleaseItem) another);
  }

  private boolean equalTo(ImmutableLinkReleaseItem another) {
    return id.equals(another.id)
        && hash.equals(another.hash)
        && value.equals(another.value)
        && contentType.equals(another.contentType)
        && articles.equals(another.articles)
        && labels.equals(another.labels);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code hash}, {@code value}, {@code contentType}, {@code articles}, {@code labels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + hash.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + contentType.hashCode();
    h += (h << 5) + articles.hashCode();
    h += (h << 5) + labels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LinkReleaseItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LinkReleaseItem")
        .omitNullValues()
        .add("id", id)
        .add("hash", hash)
        .add("value", value)
        .add("contentType", contentType)
        .add("articles", articles)
        .add("labels", labels)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.LinkReleaseItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StencilClient.LinkReleaseItem {
    @Nullable String id;
    @Nullable String hash;
    @Nullable String value;
    @Nullable String contentType;
    @Nullable List<String> articles = ImmutableList.of();
    @Nullable List<StencilClient.LocaleLabel> labels = ImmutableList.of();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("contentType")
    public void setContentType(String contentType) {
      this.contentType = contentType;
    }
    @JsonProperty("articles")
    public void setArticles(List<String> articles) {
      this.articles = articles;
    }
    @JsonProperty("labels")
    public void setLabels(List<StencilClient.LocaleLabel> labels) {
      this.labels = labels;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getHash() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public String getContentType() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getArticles() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.LocaleLabel> getLabels() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLinkReleaseItem fromJson(Json json) {
    ImmutableLinkReleaseItem.Builder builder = ImmutableLinkReleaseItem.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.contentType != null) {
      builder.contentType(json.contentType);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    if (json.labels != null) {
      builder.addAllLabels(json.labels);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.LinkReleaseItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LinkReleaseItem instance
   */
  public static ImmutableLinkReleaseItem copyOf(StencilClient.LinkReleaseItem instance) {
    if (instance instanceof ImmutableLinkReleaseItem) {
      return (ImmutableLinkReleaseItem) instance;
    }
    return ImmutableLinkReleaseItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLinkReleaseItem ImmutableLinkReleaseItem}.
   * <pre>
   * ImmutableLinkReleaseItem.builder()
   *    .id(String) // required {@link StencilClient.LinkReleaseItem#getId() id}
   *    .hash(String) // required {@link StencilClient.LinkReleaseItem#getHash() hash}
   *    .value(String) // required {@link StencilClient.LinkReleaseItem#getValue() value}
   *    .contentType(String) // required {@link StencilClient.LinkReleaseItem#getContentType() contentType}
   *    .addArticles|addAllArticles(String) // {@link StencilClient.LinkReleaseItem#getArticles() articles} elements
   *    .addLabels|addAllLabels(io.thestencil.client.api.StencilClient.LocaleLabel) // {@link StencilClient.LinkReleaseItem#getLabels() labels} elements
   *    .build();
   * </pre>
   * @return A new ImmutableLinkReleaseItem builder
   */
  public static ImmutableLinkReleaseItem.Builder builder() {
    return new ImmutableLinkReleaseItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLinkReleaseItem ImmutableLinkReleaseItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.LinkReleaseItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_HASH = 0x2L;
    private static final long INIT_BIT_VALUE = 0x4L;
    private static final long INIT_BIT_CONTENT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String hash;
    private @Nullable String value;
    private @Nullable String contentType;
    private ImmutableList.Builder<String> articles = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.LocaleLabel> labels = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.ReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.ReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.thestencil.client.api.StencilClient.LinkReleaseItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StencilClient.LinkReleaseItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof StencilClient.ReleaseItem) {
        StencilClient.ReleaseItem instance = (StencilClient.ReleaseItem) object;
        hash(instance.getHash());
        id(instance.getId());
      }
      if (object instanceof StencilClient.LinkReleaseItem) {
        StencilClient.LinkReleaseItem instance = (StencilClient.LinkReleaseItem) object;
        value(instance.getValue());
        contentType(instance.getContentType());
        addAllArticles(instance.getArticles());
        addAllLabels(instance.getLabels());
      }
    }

    /**
     * Initializes the value for the {@link StencilClient.LinkReleaseItem#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.LinkReleaseItem#getHash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.LinkReleaseItem#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.LinkReleaseItem#getContentType() contentType} attribute.
     * @param contentType The value for contentType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("contentType")
    public final Builder contentType(String contentType) {
      this.contentType = Objects.requireNonNull(contentType, "contentType");
      initBits &= ~INIT_BIT_CONTENT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.LinkReleaseItem#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.LinkReleaseItem#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.LinkReleaseItem#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<String> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link StencilClient.LinkReleaseItem#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<String> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link StencilClient.LinkReleaseItem#getLabels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel element) {
      this.labels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link StencilClient.LinkReleaseItem#getLabels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel... elements) {
      this.labels.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link StencilClient.LinkReleaseItem#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    public final Builder labels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels = ImmutableList.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link StencilClient.LinkReleaseItem#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableLinkReleaseItem ImmutableLinkReleaseItem}.
     * @return An immutable instance of LinkReleaseItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLinkReleaseItem build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLinkReleaseItem(id, hash, value, contentType, articles.build(), labels.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_CONTENT_TYPE) != 0) attributes.add("contentType");
      return "Cannot build LinkReleaseItem, some of required attributes are not set " + attributes;
    }
  }
}
