package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateBuilder.CreateLink}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateLink.builder()}.
 */
@Generated(from = "CreateBuilder.CreateLink", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateLink implements CreateBuilder.CreateLink {
  private final String value;
  private final String type;
  private final ImmutableList<String> articles;
  private final ImmutableList<StencilClient.LocaleLabel> labels;

  private ImmutableCreateLink(
      String value,
      String type,
      ImmutableList<String> articles,
      ImmutableList<StencilClient.LocaleLabel> labels) {
    this.value = value;
    this.type = type;
    this.articles = articles;
    this.labels = labels;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code articles} attribute
   */
  @JsonProperty("articles")
  @Override
  public ImmutableList<String> getArticles() {
    return articles;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @Override
  public ImmutableList<StencilClient.LocaleLabel> getLabels() {
    return labels;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateLink#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateLink withValue(String value) {
    String newValue = Objects.requireNonNull(value, "value");
    if (this.value.equals(newValue)) return this;
    return new ImmutableCreateLink(newValue, this.type, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateBuilder.CreateLink#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateLink withType(String value) {
    String newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableCreateLink(this.value, newValue, this.articles, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.CreateLink#getArticles() articles}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCreateLink withArticles(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateLink(this.value, this.type, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.CreateLink#getArticles() articles}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of articles elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCreateLink withArticles(Iterable<String> elements) {
    if (this.articles == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateLink(this.value, this.type, newValue, this.labels);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.CreateLink#getLabels() labels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCreateLink withLabels(StencilClient.LocaleLabel... elements) {
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateLink(this.value, this.type, this.articles, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CreateBuilder.CreateLink#getLabels() labels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of labels elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCreateLink withLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
    if (this.labels == elements) return this;
    ImmutableList<StencilClient.LocaleLabel> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCreateLink(this.value, this.type, this.articles, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateLink} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateLink
        && equalTo((ImmutableCreateLink) another);
  }

  private boolean equalTo(ImmutableCreateLink another) {
    return value.equals(another.value)
        && type.equals(another.type)
        && articles.equals(another.articles)
        && labels.equals(another.labels);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code type}, {@code articles}, {@code labels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + articles.hashCode();
    h += (h << 5) + labels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateLink} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CreateLink")
        .omitNullValues()
        .add("value", value)
        .add("type", type)
        .add("articles", articles)
        .add("labels", labels)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CreateBuilder.CreateLink", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CreateBuilder.CreateLink {
    @Nullable String value;
    @Nullable String type;
    @Nullable List<String> articles = ImmutableList.of();
    @Nullable List<StencilClient.LocaleLabel> labels = ImmutableList.of();
    @JsonProperty("value")
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("articles")
    public void setArticles(List<String> articles) {
      this.articles = articles;
    }
    @JsonProperty("labels")
    public void setLabels(List<StencilClient.LocaleLabel> labels) {
      this.labels = labels;
    }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getArticles() { throw new UnsupportedOperationException(); }
    @Override
    public List<StencilClient.LocaleLabel> getLabels() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreateLink fromJson(Json json) {
    ImmutableCreateLink.Builder builder = ImmutableCreateLink.builder();
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.articles != null) {
      builder.addAllArticles(json.articles);
    }
    if (json.labels != null) {
      builder.addAllLabels(json.labels);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CreateBuilder.CreateLink} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateLink instance
   */
  public static ImmutableCreateLink copyOf(CreateBuilder.CreateLink instance) {
    if (instance instanceof ImmutableCreateLink) {
      return (ImmutableCreateLink) instance;
    }
    return ImmutableCreateLink.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateLink ImmutableCreateLink}.
   * <pre>
   * ImmutableCreateLink.builder()
   *    .value(String) // required {@link CreateBuilder.CreateLink#getValue() value}
   *    .type(String) // required {@link CreateBuilder.CreateLink#getType() type}
   *    .addArticles|addAllArticles(String) // {@link CreateBuilder.CreateLink#getArticles() articles} elements
   *    .addLabels|addAllLabels(io.thestencil.client.api.StencilClient.LocaleLabel) // {@link CreateBuilder.CreateLink#getLabels() labels} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCreateLink builder
   */
  public static ImmutableCreateLink.Builder builder() {
    return new ImmutableCreateLink.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateLink ImmutableCreateLink}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateBuilder.CreateLink", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String value;
    private @Nullable String type;
    private ImmutableList.Builder<String> articles = ImmutableList.builder();
    private ImmutableList.Builder<StencilClient.LocaleLabel> labels = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateLink} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateBuilder.CreateLink instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      type(instance.getType());
      addAllArticles(instance.getArticles());
      addAllLabels(instance.getLabels());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateLink#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("value")
    public final Builder value(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateBuilder.CreateLink#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link CreateBuilder.CreateLink#getArticles() articles} list.
     * @param element A articles element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String element) {
      this.articles.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateBuilder.CreateLink#getArticles() articles} list.
     * @param elements An array of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addArticles(String... elements) {
      this.articles.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateBuilder.CreateLink#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("articles")
    public final Builder articles(Iterable<String> elements) {
      this.articles = ImmutableList.builder();
      return addAllArticles(elements);
    }

    /**
     * Adds elements to {@link CreateBuilder.CreateLink#getArticles() articles} list.
     * @param elements An iterable of articles elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllArticles(Iterable<String> elements) {
      this.articles.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link CreateBuilder.CreateLink#getLabels() labels} list.
     * @param element A labels element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel element) {
      this.labels.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CreateBuilder.CreateLink#getLabels() labels} list.
     * @param elements An array of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addLabels(StencilClient.LocaleLabel... elements) {
      this.labels.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateBuilder.CreateLink#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("labels")
    public final Builder labels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels = ImmutableList.builder();
      return addAllLabels(elements);
    }

    /**
     * Adds elements to {@link CreateBuilder.CreateLink#getLabels() labels} list.
     * @param elements An iterable of labels elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllLabels(Iterable<? extends StencilClient.LocaleLabel> elements) {
      this.labels.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateLink ImmutableCreateLink}.
     * @return An immutable instance of CreateLink
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateLink build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCreateLink(value, type, articles.build(), labels.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build CreateLink, some of required attributes are not set " + attributes;
    }
  }
}
