/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api.beans;

import com.google.common.base.MoreObjects;
import io.thestencil.client.api.MigrationBuilder;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TopicHeadingBean
implements MigrationBuilder.TopicHeading {
    private String id;
    private String name;
    private Integer order;
    private Integer level;

    public TopicHeadingBean(String id, String name, Integer order, Integer level) {
        this.id = Objects.requireNonNull(id, "id");
        this.name = Objects.requireNonNull(name, "name");
        this.order = Objects.requireNonNull(order, "order");
        this.level = Objects.requireNonNull(level, "level");
    }

    public TopicHeadingBean() {
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public Integer getLevel() {
        return this.level;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TopicHeadingBean && this.equalTo((TopicHeadingBean)another);
    }

    private boolean equalTo(TopicHeadingBean another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.order.equals(another.order) && this.level.equals(another.level);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.order.hashCode();
        h += (h << 5) + this.level.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TopicHeading").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("order", (Object)this.order).add("level", (Object)this.level).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_ORDER = 4L;
        private static final long INIT_BIT_LEVEL = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private Integer order;
        @Nullable
        private Integer level;

        private Builder() {
        }

        public final Builder from(MigrationBuilder.TopicHeading instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.order(instance.getOrder());
            this.level(instance.getLevel());
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder order(Integer order) {
            this.order = Objects.requireNonNull(order, "order");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder level(Integer level) {
            this.level = Objects.requireNonNull(level, "level");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public TopicHeadingBean build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TopicHeadingBean(this.id, this.name, this.order, this.level);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("order");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("level");
            }
            return "Cannot build TopicHeading, some of required attributes are not set " + attributes;
        }
    }
}

