/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api.beans;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.thestencil.client.api.MigrationBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TopicBean
implements MigrationBuilder.Topic {
    private String id;
    private String name;
    private List<String> links;
    private List<MigrationBuilder.TopicHeading> headings;
    @Nullable
    private String parent;
    @Nullable
    private String blob;

    public TopicBean(String id, String name, Collection<String> links, Collection<? extends MigrationBuilder.TopicHeading> headings, @Nullable String parent, @Nullable String blob) {
        this.id = Objects.requireNonNull(id, "id");
        this.name = Objects.requireNonNull(name, "name");
        this.links = List.copyOf(links);
        this.headings = List.copyOf(headings);
        this.parent = parent;
        this.blob = blob;
    }

    public TopicBean() {
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLinks(List<String> links) {
        this.links = links;
    }

    public void setHeadings(List<MigrationBuilder.TopicHeading> headings) {
        this.headings = headings;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public void setBlob(String blob) {
        this.blob = blob;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getLinks() {
        return this.links;
    }

    @Override
    public List<MigrationBuilder.TopicHeading> getHeadings() {
        return this.headings;
    }

    @Override
    @Nullable
    public String getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public String getBlob() {
        return this.blob;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TopicBean && this.equalTo((TopicBean)another);
    }

    private boolean equalTo(TopicBean another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.links.equals(another.links) && this.headings.equals(another.headings) && Objects.equals(this.parent, another.parent) && Objects.equals(this.blob, another.blob);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + this.headings.hashCode();
        h += (h << 5) + Objects.hashCode(this.parent);
        h += (h << 5) + Objects.hashCode(this.blob);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Topic").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("links", this.links).add("headings", this.headings).add("parent", (Object)this.parent).add("blob", (Object)this.blob).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> links = ImmutableList.builder();
        private ImmutableList.Builder<MigrationBuilder.TopicHeading> headings = ImmutableList.builder();
        @Nullable
        private String parent;
        @Nullable
        private String blob;

        private Builder() {
        }

        public final Builder from(MigrationBuilder.Topic instance) {
            String blobValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            this.addAllLinks(instance.getLinks());
            this.addAllHeadings(instance.getHeadings());
            String parentValue = instance.getParent();
            if (parentValue != null) {
                this.parent(parentValue);
            }
            if ((blobValue = instance.getBlob()) != null) {
                this.blob(blobValue);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addLinks(String element) {
            this.links.add((Object)element);
            return this;
        }

        public final Builder addLinks(String ... elements) {
            this.links.add((Object[])elements);
            return this;
        }

        public final Builder links(Iterable<String> elements) {
            this.links = ImmutableList.builder();
            return this.addAllLinks(elements);
        }

        public final Builder addAllLinks(Iterable<String> elements) {
            this.links.addAll(elements);
            return this;
        }

        public final Builder addHeadings(MigrationBuilder.TopicHeading element) {
            this.headings.add((Object)element);
            return this;
        }

        public final Builder addHeadings(MigrationBuilder.TopicHeading ... elements) {
            this.headings.add((Object[])elements);
            return this;
        }

        public final Builder headings(Iterable<? extends MigrationBuilder.TopicHeading> elements) {
            this.headings = ImmutableList.builder();
            return this.addAllHeadings(elements);
        }

        public final Builder addAllHeadings(Iterable<? extends MigrationBuilder.TopicHeading> elements) {
            this.headings.addAll(elements);
            return this;
        }

        public final Builder parent(@Nullable String parent) {
            this.parent = parent;
            return this;
        }

        public final Builder blob(@Nullable String blob) {
            this.blob = blob;
            return this;
        }

        public TopicBean build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new TopicBean(this.id, this.name, (Collection<String>)this.links.build(), (Collection<? extends MigrationBuilder.TopicHeading>)this.headings.build(), this.parent, this.blob);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Topic, some of required attributes are not set " + attributes;
        }
    }
}

