/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.Link", generator="Immutables")
@Immutable
public final class ImmutableLink
implements StencilClient.Link {
    private final ImmutableList<String> articles;
    private final String locale;
    private final String content;
    private final String contentType;
    private final String description;

    private ImmutableLink(ImmutableList<String> articles, String locale, String content, String contentType, String description) {
        this.articles = articles;
        this.locale = locale;
        this.content = content;
        this.contentType = contentType;
        this.description = description;
    }

    @JsonProperty(value="articles")
    public ImmutableList<String> getArticles() {
        return this.articles;
    }

    @Override
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    @Override
    @JsonProperty(value="content")
    public String getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="contentType")
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public final ImmutableLink withArticles(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLink((ImmutableList<String>)newValue, this.locale, this.content, this.contentType, this.description);
    }

    public final ImmutableLink withArticles(Iterable<String> elements) {
        if (this.articles == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLink((ImmutableList<String>)newValue, this.locale, this.content, this.contentType, this.description);
    }

    public final ImmutableLink withLocale(String value) {
        String newValue = Objects.requireNonNull(value, "locale");
        if (this.locale.equals(newValue)) {
            return this;
        }
        return new ImmutableLink(this.articles, newValue, this.content, this.contentType, this.description);
    }

    public final ImmutableLink withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableLink(this.articles, this.locale, newValue, this.contentType, this.description);
    }

    public final ImmutableLink withContentType(String value) {
        String newValue = Objects.requireNonNull(value, "contentType");
        if (this.contentType.equals(newValue)) {
            return this;
        }
        return new ImmutableLink(this.articles, this.locale, this.content, newValue, this.description);
    }

    public final ImmutableLink withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableLink(this.articles, this.locale, this.content, this.contentType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLink && this.equalTo((ImmutableLink)another);
    }

    private boolean equalTo(ImmutableLink another) {
        return this.articles.equals(another.articles) && this.locale.equals(another.locale) && this.content.equals(another.content) && this.contentType.equals(another.contentType) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.articles.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.contentType.hashCode();
        h += (h << 5) + this.description.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Link").omitNullValues().add("articles", this.articles).add("locale", (Object)this.locale).add("content", (Object)this.content).add("contentType", (Object)this.contentType).add("description", (Object)this.description).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLink fromJson(Json json) {
        Builder builder = ImmutableLink.builder();
        if (json.articles != null) {
            builder.addAllArticles(json.articles);
        }
        if (json.locale != null) {
            builder.locale(json.locale);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.contentType != null) {
            builder.contentType(json.contentType);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableLink copyOf(StencilClient.Link instance) {
        if (instance instanceof ImmutableLink) {
            return (ImmutableLink)instance;
        }
        return ImmutableLink.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.Link", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOCALE = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private static final long INIT_BIT_CONTENT_TYPE = 4L;
        private static final long INIT_BIT_DESCRIPTION = 8L;
        private long initBits = 15L;
        private ImmutableList.Builder<String> articles = ImmutableList.builder();
        @Nullable
        private String locale;
        @Nullable
        private String content;
        @Nullable
        private String contentType;
        @Nullable
        private String description;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.Link instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllArticles(instance.getArticles());
            this.locale(instance.getLocale());
            this.content(instance.getContent());
            this.contentType(instance.getContentType());
            this.description(instance.getDescription());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String element) {
            this.articles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addArticles(String ... elements) {
            this.articles.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(Iterable<String> elements) {
            this.articles = ImmutableList.builder();
            return this.addAllArticles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllArticles(Iterable<String> elements) {
            this.articles.addAll(elements);
            return this;
        }

        @JsonProperty(value="locale")
        @CanIgnoreReturnValue
        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="contentType")
        @CanIgnoreReturnValue
        public final Builder contentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableLink build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLink((ImmutableList<String>)this.articles.build(), this.locale, this.content, this.contentType, this.description);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("locale");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("contentType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build Link, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.Link", generator="Immutables")
    static final class Json
    implements StencilClient.Link {
        @Nullable
        List<String> articles = ImmutableList.of();
        @Nullable
        String locale;
        @Nullable
        String content;
        @Nullable
        String contentType;
        @Nullable
        String description;

        Json() {
        }

        @JsonProperty(value="articles")
        public void setArticles(List<String> articles) {
            this.articles = articles;
        }

        @JsonProperty(value="locale")
        public void setLocale(String locale) {
            this.locale = locale;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty(value="contentType")
        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public List<String> getArticles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContentType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }
    }
}

