package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StencilClient.Entity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEntity.builder()}.
 */
@Generated(from = "StencilClient.Entity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableEntity<T extends StencilClient.EntityBody>
    implements StencilClient.Entity<T> {
  private final String id;
  private final StencilClient.EntityType type;
  private final T body;

  private ImmutableEntity(String id, StencilClient.EntityType type, T body) {
    this.id = id;
    this.type = type;
    this.body = body;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public StencilClient.EntityType getType() {
    return type;
  }

  /**
   * @return The value of the {@code body} attribute
   */
  @JsonProperty("body")
  @Override
  public T getBody() {
    return body;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Entity#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntity<T> withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableEntity<>(newValue, this.type, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Entity#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntity<T> withType(StencilClient.EntityType value) {
    if (this.type == value) return this;
    StencilClient.EntityType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableEntity<>(this.id, newValue, this.body);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StencilClient.Entity#getBody() body} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for body
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEntity<T> withBody(T value) {
    if (this.body == value) return this;
    T newValue = Objects.requireNonNull(value, "body");
    return new ImmutableEntity<>(this.id, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEntity<?>
        && equalTo((ImmutableEntity<?>) another);
  }

  private boolean equalTo(ImmutableEntity<?> another) {
    return id.equals(another.id)
        && type.equals(another.type)
        && body.equals(another.body);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code type}, {@code body}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + body.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Entity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Entity")
        .omitNullValues()
        .add("id", id)
        .add("type", type)
        .add("body", body)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "StencilClient.Entity", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json<T extends StencilClient.EntityBody>
      implements StencilClient.Entity<T> {
    @Nullable String id;
    @Nullable StencilClient.EntityType type;
    @Nullable T body;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("type")
    public void setType(StencilClient.EntityType type) {
      this.type = type;
    }
    @JsonProperty("body")
    public void setBody(T body) {
      this.body = body;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public StencilClient.EntityType getType() { throw new UnsupportedOperationException(); }
    @Override
    public T getBody() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param <T> generic parameter T
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static <T extends StencilClient.EntityBody> ImmutableEntity<T> fromJson(Json<T> json) {
    ImmutableEntity.Builder<T> builder = ImmutableEntity.<T>builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link StencilClient.Entity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Entity instance
   */
  public static <T extends StencilClient.EntityBody> ImmutableEntity<T> copyOf(StencilClient.Entity<T> instance) {
    if (instance instanceof ImmutableEntity<?>) {
      return (ImmutableEntity<T>) instance;
    }
    return ImmutableEntity.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEntity ImmutableEntity}.
   * <pre>
   * ImmutableEntity.&amp;lt;T&amp;gt;builder()
   *    .id(String) // required {@link StencilClient.Entity#getId() id}
   *    .type(io.thestencil.client.api.StencilClient.EntityType) // required {@link StencilClient.Entity#getType() type}
   *    .body(T) // required {@link StencilClient.Entity#getBody() body}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableEntity builder
   */
  public static <T extends StencilClient.EntityBody> ImmutableEntity.Builder<T> builder() {
    return new ImmutableEntity.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableEntity ImmutableEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StencilClient.Entity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T extends StencilClient.EntityBody> {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private static final long INIT_BIT_BODY = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable StencilClient.EntityType type;
    private @Nullable T body;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Entity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(StencilClient.Entity<T> instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      type(instance.getType());
      body(instance.getBody());
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Entity#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder<T> id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Entity#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder<T> type(StencilClient.EntityType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link StencilClient.Entity#getBody() body} attribute.
     * @param body The value for body 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("body")
    public final Builder<T> body(T body) {
      this.body = Objects.requireNonNull(body, "body");
      initBits &= ~INIT_BIT_BODY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEntity ImmutableEntity}.
     * @return An immutable instance of Entity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEntity<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEntity<>(id, type, body);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_BODY) != 0) attributes.add("body");
      return "Cannot build Entity, some of required attributes are not set " + attributes;
    }
  }
}
