/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api.beans;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.thestencil.client.api.MigrationBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class LocalizedSiteBean
implements MigrationBuilder.LocalizedSite {
    private String id;
    private String images;
    private String locale;
    private Map<String, MigrationBuilder.Topic> topics;
    private Map<String, MigrationBuilder.TopicBlob> blobs;
    private Map<String, MigrationBuilder.TopicLink> links;

    public LocalizedSiteBean(String id, String images, String locale, Map<String, ? extends MigrationBuilder.Topic> topics, Map<String, ? extends MigrationBuilder.TopicBlob> blobs, Map<String, ? extends MigrationBuilder.TopicLink> links) {
        this.id = Objects.requireNonNull(id, "id");
        this.images = Objects.requireNonNull(images, "images");
        this.locale = Objects.requireNonNull(locale, "locale");
        this.topics = new LinkedHashMap<String, MigrationBuilder.Topic>(topics);
        this.blobs = new LinkedHashMap<String, MigrationBuilder.TopicBlob>(blobs);
        this.links = new LinkedHashMap<String, MigrationBuilder.TopicLink>(links);
    }

    public LocalizedSiteBean() {
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setImages(String images) {
        this.images = images;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setTopics(Map<String, MigrationBuilder.Topic> topics) {
        this.topics = topics;
    }

    public void setBlobs(Map<String, MigrationBuilder.TopicBlob> blobs) {
        this.blobs = blobs;
    }

    public void setLinks(Map<String, MigrationBuilder.TopicLink> links) {
        this.links = links;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getImages() {
        return this.images;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public Map<String, MigrationBuilder.Topic> getTopics() {
        return this.topics;
    }

    @Override
    public Map<String, MigrationBuilder.TopicBlob> getBlobs() {
        return this.blobs;
    }

    @Override
    public Map<String, MigrationBuilder.TopicLink> getLinks() {
        return this.links;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LocalizedSiteBean && this.equalTo((LocalizedSiteBean)another);
    }

    private boolean equalTo(LocalizedSiteBean another) {
        return this.id.equals(another.id) && this.images.equals(another.images) && this.locale.equals(another.locale) && this.topics.equals(another.topics) && this.blobs.equals(another.blobs) && this.links.equals(another.links);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.images.hashCode();
        h += (h << 5) + this.locale.hashCode();
        h += (h << 5) + this.topics.hashCode();
        h += (h << 5) + this.blobs.hashCode();
        h += (h << 5) + this.links.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LocalizedSite").omitNullValues().add("id", (Object)this.id).add("images", (Object)this.images).add("locale", (Object)this.locale).add("topics", this.topics).add("blobs", this.blobs).add("links", this.links).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_IMAGES = 2L;
        private static final long INIT_BIT_LOCALE = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String images;
        @Nullable
        private String locale;
        private ImmutableMap.Builder<String, MigrationBuilder.Topic> topics = ImmutableMap.builder();
        private ImmutableMap.Builder<String, MigrationBuilder.TopicBlob> blobs = ImmutableMap.builder();
        private ImmutableMap.Builder<String, MigrationBuilder.TopicLink> links = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(MigrationBuilder.LocalizedSite instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.images(instance.getImages());
            this.locale(instance.getLocale());
            this.putAllTopics(instance.getTopics());
            this.putAllBlobs(instance.getBlobs());
            this.putAllLinks(instance.getLinks());
            return this;
        }

        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder images(String images) {
            this.images = Objects.requireNonNull(images, "images");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder locale(String locale) {
            this.locale = Objects.requireNonNull(locale, "locale");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder putTopics(String key, MigrationBuilder.Topic value) {
            this.topics.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putTopics(Map.Entry<String, ? extends MigrationBuilder.Topic> entry) {
            this.topics.put(entry);
            return this;
        }

        public final Builder topics(Map<String, ? extends MigrationBuilder.Topic> entries) {
            this.topics = ImmutableMap.builder();
            return this.putAllTopics(entries);
        }

        public final Builder putAllTopics(Map<String, ? extends MigrationBuilder.Topic> entries) {
            this.topics.putAll(entries);
            return this;
        }

        public final Builder putBlobs(String key, MigrationBuilder.TopicBlob value) {
            this.blobs.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putBlobs(Map.Entry<String, ? extends MigrationBuilder.TopicBlob> entry) {
            this.blobs.put(entry);
            return this;
        }

        public final Builder blobs(Map<String, ? extends MigrationBuilder.TopicBlob> entries) {
            this.blobs = ImmutableMap.builder();
            return this.putAllBlobs(entries);
        }

        public final Builder putAllBlobs(Map<String, ? extends MigrationBuilder.TopicBlob> entries) {
            this.blobs.putAll(entries);
            return this;
        }

        public final Builder putLinks(String key, MigrationBuilder.TopicLink value) {
            this.links.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putLinks(Map.Entry<String, ? extends MigrationBuilder.TopicLink> entry) {
            this.links.put(entry);
            return this;
        }

        public final Builder links(Map<String, ? extends MigrationBuilder.TopicLink> entries) {
            this.links = ImmutableMap.builder();
            return this.putAllLinks(entries);
        }

        public final Builder putAllLinks(Map<String, ? extends MigrationBuilder.TopicLink> entries) {
            this.links.putAll(entries);
            return this;
        }

        public LocalizedSiteBean build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new LocalizedSiteBean(this.id, this.images, this.locale, (Map<String, ? extends MigrationBuilder.Topic>)this.topics.build(), (Map<String, ? extends MigrationBuilder.TopicBlob>)this.blobs.build(), (Map<String, ? extends MigrationBuilder.TopicLink>)this.links.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("images");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("locale");
            }
            return "Cannot build LocalizedSite, some of required attributes are not set " + attributes;
        }
    }
}

