/*
 * Decompiled with CFR 0.152.
 */
package io.thestencil.client.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.thestencil.client.api.StencilClient;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StencilClient.SiteState", generator="Immutables")
@Immutable
public final class ImmutableSiteState
implements StencilClient.SiteState {
    private final String name;
    private final StencilClient.SiteContentType contentType;
    private final ImmutableMap<String, StencilClient.Entity<StencilClient.Release>> releases;
    private final ImmutableMap<String, StencilClient.Entity<StencilClient.Locale>> locales;
    private final ImmutableMap<String, StencilClient.Entity<StencilClient.Page>> pages;
    private final ImmutableMap<String, StencilClient.Entity<StencilClient.Link>> links;
    private final ImmutableMap<String, StencilClient.Entity<StencilClient.Article>> articles;
    private final ImmutableMap<String, StencilClient.Entity<StencilClient.Workflow>> workflows;

    private ImmutableSiteState(String name, StencilClient.SiteContentType contentType, ImmutableMap<String, StencilClient.Entity<StencilClient.Release>> releases, ImmutableMap<String, StencilClient.Entity<StencilClient.Locale>> locales, ImmutableMap<String, StencilClient.Entity<StencilClient.Page>> pages, ImmutableMap<String, StencilClient.Entity<StencilClient.Link>> links, ImmutableMap<String, StencilClient.Entity<StencilClient.Article>> articles, ImmutableMap<String, StencilClient.Entity<StencilClient.Workflow>> workflows) {
        this.name = name;
        this.contentType = contentType;
        this.releases = releases;
        this.locales = locales;
        this.pages = pages;
        this.links = links;
        this.articles = articles;
        this.workflows = workflows;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="contentType")
    public StencilClient.SiteContentType getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="releases")
    public ImmutableMap<String, StencilClient.Entity<StencilClient.Release>> getReleases() {
        return this.releases;
    }

    @JsonProperty(value="locales")
    public ImmutableMap<String, StencilClient.Entity<StencilClient.Locale>> getLocales() {
        return this.locales;
    }

    @JsonProperty(value="pages")
    public ImmutableMap<String, StencilClient.Entity<StencilClient.Page>> getPages() {
        return this.pages;
    }

    @JsonProperty(value="links")
    public ImmutableMap<String, StencilClient.Entity<StencilClient.Link>> getLinks() {
        return this.links;
    }

    @JsonProperty(value="articles")
    public ImmutableMap<String, StencilClient.Entity<StencilClient.Article>> getArticles() {
        return this.articles;
    }

    @JsonProperty(value="workflows")
    public ImmutableMap<String, StencilClient.Entity<StencilClient.Workflow>> getWorkflows() {
        return this.workflows;
    }

    public final ImmutableSiteState withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSiteState(newValue, this.contentType, this.releases, this.locales, this.pages, this.links, this.articles, this.workflows);
    }

    public final ImmutableSiteState withContentType(StencilClient.SiteContentType value) {
        if (this.contentType == value) {
            return this;
        }
        StencilClient.SiteContentType newValue = Objects.requireNonNull(value, "contentType");
        if (this.contentType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSiteState(this.name, newValue, this.releases, this.locales, this.pages, this.links, this.articles, this.workflows);
    }

    public final ImmutableSiteState withReleases(Map<String, ? extends StencilClient.Entity<StencilClient.Release>> entries) {
        if (this.releases == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSiteState(this.name, this.contentType, (ImmutableMap<String, StencilClient.Entity<StencilClient.Release>>)newValue, this.locales, this.pages, this.links, this.articles, this.workflows);
    }

    public final ImmutableSiteState withLocales(Map<String, ? extends StencilClient.Entity<StencilClient.Locale>> entries) {
        if (this.locales == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSiteState(this.name, this.contentType, this.releases, (ImmutableMap<String, StencilClient.Entity<StencilClient.Locale>>)newValue, this.pages, this.links, this.articles, this.workflows);
    }

    public final ImmutableSiteState withPages(Map<String, ? extends StencilClient.Entity<StencilClient.Page>> entries) {
        if (this.pages == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSiteState(this.name, this.contentType, this.releases, this.locales, (ImmutableMap<String, StencilClient.Entity<StencilClient.Page>>)newValue, this.links, this.articles, this.workflows);
    }

    public final ImmutableSiteState withLinks(Map<String, ? extends StencilClient.Entity<StencilClient.Link>> entries) {
        if (this.links == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSiteState(this.name, this.contentType, this.releases, this.locales, this.pages, (ImmutableMap<String, StencilClient.Entity<StencilClient.Link>>)newValue, this.articles, this.workflows);
    }

    public final ImmutableSiteState withArticles(Map<String, ? extends StencilClient.Entity<StencilClient.Article>> entries) {
        if (this.articles == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSiteState(this.name, this.contentType, this.releases, this.locales, this.pages, this.links, (ImmutableMap<String, StencilClient.Entity<StencilClient.Article>>)newValue, this.workflows);
    }

    public final ImmutableSiteState withWorkflows(Map<String, ? extends StencilClient.Entity<StencilClient.Workflow>> entries) {
        if (this.workflows == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableSiteState(this.name, this.contentType, this.releases, this.locales, this.pages, this.links, this.articles, (ImmutableMap<String, StencilClient.Entity<StencilClient.Workflow>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSiteState && this.equalTo((ImmutableSiteState)another);
    }

    private boolean equalTo(ImmutableSiteState another) {
        return this.name.equals(another.name) && this.contentType.equals((Object)another.contentType) && this.releases.equals(another.releases) && this.locales.equals(another.locales) && this.pages.equals(another.pages) && this.links.equals(another.links) && this.articles.equals(another.articles) && this.workflows.equals(another.workflows);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.contentType.hashCode();
        h += (h << 5) + this.releases.hashCode();
        h += (h << 5) + this.locales.hashCode();
        h += (h << 5) + this.pages.hashCode();
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + this.articles.hashCode();
        h += (h << 5) + this.workflows.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SiteState").omitNullValues().add("name", (Object)this.name).add("contentType", (Object)this.contentType).add("releases", this.releases).add("locales", this.locales).add("pages", this.pages).add("links", this.links).add("articles", this.articles).add("workflows", this.workflows).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSiteState fromJson(Json json) {
        Builder builder = ImmutableSiteState.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.contentType != null) {
            builder.contentType(json.contentType);
        }
        if (json.releases != null) {
            builder.putAllReleases(json.releases);
        }
        if (json.locales != null) {
            builder.putAllLocales(json.locales);
        }
        if (json.pages != null) {
            builder.putAllPages(json.pages);
        }
        if (json.links != null) {
            builder.putAllLinks(json.links);
        }
        if (json.articles != null) {
            builder.putAllArticles(json.articles);
        }
        if (json.workflows != null) {
            builder.putAllWorkflows(json.workflows);
        }
        return builder.build();
    }

    public static ImmutableSiteState copyOf(StencilClient.SiteState instance) {
        if (instance instanceof ImmutableSiteState) {
            return (ImmutableSiteState)instance;
        }
        return ImmutableSiteState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StencilClient.SiteState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_CONTENT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private StencilClient.SiteContentType contentType;
        private ImmutableMap.Builder<String, StencilClient.Entity<StencilClient.Release>> releases = ImmutableMap.builder();
        private ImmutableMap.Builder<String, StencilClient.Entity<StencilClient.Locale>> locales = ImmutableMap.builder();
        private ImmutableMap.Builder<String, StencilClient.Entity<StencilClient.Page>> pages = ImmutableMap.builder();
        private ImmutableMap.Builder<String, StencilClient.Entity<StencilClient.Link>> links = ImmutableMap.builder();
        private ImmutableMap.Builder<String, StencilClient.Entity<StencilClient.Article>> articles = ImmutableMap.builder();
        private ImmutableMap.Builder<String, StencilClient.Entity<StencilClient.Workflow>> workflows = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StencilClient.SiteState instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.contentType(instance.getContentType());
            this.putAllReleases(instance.getReleases());
            this.putAllLocales(instance.getLocales());
            this.putAllPages(instance.getPages());
            this.putAllLinks(instance.getLinks());
            this.putAllArticles(instance.getArticles());
            this.putAllWorkflows(instance.getWorkflows());
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="contentType")
        @CanIgnoreReturnValue
        public final Builder contentType(StencilClient.SiteContentType contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putReleases(String key, StencilClient.Entity<StencilClient.Release> value) {
            this.releases.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putReleases(Map.Entry<String, ? extends StencilClient.Entity<StencilClient.Release>> entry) {
            this.releases.put(entry);
            return this;
        }

        @JsonProperty(value="releases")
        @CanIgnoreReturnValue
        public final Builder releases(Map<String, ? extends StencilClient.Entity<StencilClient.Release>> entries) {
            this.releases = ImmutableMap.builder();
            return this.putAllReleases(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllReleases(Map<String, ? extends StencilClient.Entity<StencilClient.Release>> entries) {
            this.releases.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putLocales(String key, StencilClient.Entity<StencilClient.Locale> value) {
            this.locales.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putLocales(Map.Entry<String, ? extends StencilClient.Entity<StencilClient.Locale>> entry) {
            this.locales.put(entry);
            return this;
        }

        @JsonProperty(value="locales")
        @CanIgnoreReturnValue
        public final Builder locales(Map<String, ? extends StencilClient.Entity<StencilClient.Locale>> entries) {
            this.locales = ImmutableMap.builder();
            return this.putAllLocales(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllLocales(Map<String, ? extends StencilClient.Entity<StencilClient.Locale>> entries) {
            this.locales.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPages(String key, StencilClient.Entity<StencilClient.Page> value) {
            this.pages.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putPages(Map.Entry<String, ? extends StencilClient.Entity<StencilClient.Page>> entry) {
            this.pages.put(entry);
            return this;
        }

        @JsonProperty(value="pages")
        @CanIgnoreReturnValue
        public final Builder pages(Map<String, ? extends StencilClient.Entity<StencilClient.Page>> entries) {
            this.pages = ImmutableMap.builder();
            return this.putAllPages(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllPages(Map<String, ? extends StencilClient.Entity<StencilClient.Page>> entries) {
            this.pages.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putLinks(String key, StencilClient.Entity<StencilClient.Link> value) {
            this.links.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putLinks(Map.Entry<String, ? extends StencilClient.Entity<StencilClient.Link>> entry) {
            this.links.put(entry);
            return this;
        }

        @JsonProperty(value="links")
        @CanIgnoreReturnValue
        public final Builder links(Map<String, ? extends StencilClient.Entity<StencilClient.Link>> entries) {
            this.links = ImmutableMap.builder();
            return this.putAllLinks(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllLinks(Map<String, ? extends StencilClient.Entity<StencilClient.Link>> entries) {
            this.links.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putArticles(String key, StencilClient.Entity<StencilClient.Article> value) {
            this.articles.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putArticles(Map.Entry<String, ? extends StencilClient.Entity<StencilClient.Article>> entry) {
            this.articles.put(entry);
            return this;
        }

        @JsonProperty(value="articles")
        @CanIgnoreReturnValue
        public final Builder articles(Map<String, ? extends StencilClient.Entity<StencilClient.Article>> entries) {
            this.articles = ImmutableMap.builder();
            return this.putAllArticles(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllArticles(Map<String, ? extends StencilClient.Entity<StencilClient.Article>> entries) {
            this.articles.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putWorkflows(String key, StencilClient.Entity<StencilClient.Workflow> value) {
            this.workflows.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putWorkflows(Map.Entry<String, ? extends StencilClient.Entity<StencilClient.Workflow>> entry) {
            this.workflows.put(entry);
            return this;
        }

        @JsonProperty(value="workflows")
        @CanIgnoreReturnValue
        public final Builder workflows(Map<String, ? extends StencilClient.Entity<StencilClient.Workflow>> entries) {
            this.workflows = ImmutableMap.builder();
            return this.putAllWorkflows(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllWorkflows(Map<String, ? extends StencilClient.Entity<StencilClient.Workflow>> entries) {
            this.workflows.putAll(entries);
            return this;
        }

        public ImmutableSiteState build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSiteState(this.name, this.contentType, (ImmutableMap<String, StencilClient.Entity<StencilClient.Release>>)this.releases.build(), (ImmutableMap<String, StencilClient.Entity<StencilClient.Locale>>)this.locales.build(), (ImmutableMap<String, StencilClient.Entity<StencilClient.Page>>)this.pages.build(), (ImmutableMap<String, StencilClient.Entity<StencilClient.Link>>)this.links.build(), (ImmutableMap<String, StencilClient.Entity<StencilClient.Article>>)this.articles.build(), (ImmutableMap<String, StencilClient.Entity<StencilClient.Workflow>>)this.workflows.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentType");
            }
            return "Cannot build SiteState, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StencilClient.SiteState", generator="Immutables")
    static final class Json
    implements StencilClient.SiteState {
        @Nullable
        String name;
        @Nullable
        StencilClient.SiteContentType contentType;
        @Nullable
        Map<String, StencilClient.Entity<StencilClient.Release>> releases = ImmutableMap.of();
        @Nullable
        Map<String, StencilClient.Entity<StencilClient.Locale>> locales = ImmutableMap.of();
        @Nullable
        Map<String, StencilClient.Entity<StencilClient.Page>> pages = ImmutableMap.of();
        @Nullable
        Map<String, StencilClient.Entity<StencilClient.Link>> links = ImmutableMap.of();
        @Nullable
        Map<String, StencilClient.Entity<StencilClient.Article>> articles = ImmutableMap.of();
        @Nullable
        Map<String, StencilClient.Entity<StencilClient.Workflow>> workflows = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="contentType")
        public void setContentType(StencilClient.SiteContentType contentType) {
            this.contentType = contentType;
        }

        @JsonProperty(value="releases")
        public void setReleases(Map<String, StencilClient.Entity<StencilClient.Release>> releases) {
            this.releases = releases;
        }

        @JsonProperty(value="locales")
        public void setLocales(Map<String, StencilClient.Entity<StencilClient.Locale>> locales) {
            this.locales = locales;
        }

        @JsonProperty(value="pages")
        public void setPages(Map<String, StencilClient.Entity<StencilClient.Page>> pages) {
            this.pages = pages;
        }

        @JsonProperty(value="links")
        public void setLinks(Map<String, StencilClient.Entity<StencilClient.Link>> links) {
            this.links = links;
        }

        @JsonProperty(value="articles")
        public void setArticles(Map<String, StencilClient.Entity<StencilClient.Article>> articles) {
            this.articles = articles;
        }

        @JsonProperty(value="workflows")
        public void setWorkflows(Map<String, StencilClient.Entity<StencilClient.Workflow>> workflows) {
            this.workflows = workflows;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public StencilClient.SiteContentType getContentType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, StencilClient.Entity<StencilClient.Release>> getReleases() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, StencilClient.Entity<StencilClient.Locale>> getLocales() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, StencilClient.Entity<StencilClient.Page>> getPages() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, StencilClient.Entity<StencilClient.Link>> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, StencilClient.Entity<StencilClient.Article>> getArticles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, StencilClient.Entity<StencilClient.Workflow>> getWorkflows() {
            throw new UnsupportedOperationException();
        }
    }
}

