/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.validator;

import io.thedocs.soyuz.err.Err;
import io.thedocs.soyuz.err.Errors;
import io.thedocs.soyuz.validator.FluentValidatorBuilder;
import io.thedocs.soyuz.validator.FluentValidatorRule;
import io.thedocs.soyuz.validator.Fv;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class FluentValidatorObjects {

    public static class ErrorUtils {
        public static Errors addParentProperty(Errors errors, String parentProperty) {
            ArrayList<Err> answer = new ArrayList<Err>(errors.get().size());
            for (Err error : errors) {
                answer.add(ErrorUtils.addParentProperty(error, parentProperty));
            }
            return Errors.reject(answer);
        }

        public static Err addParentProperty(Err error, String parentProperty) {
            return error.toBuilder().field(PropertyUtils.mix(parentProperty, error.getField())).build();
        }
    }

    public static class PropertyUtils {
        public static String mix(String parent, String child) {
            if (parent == null) {
                return child;
            }
            if (child == null) {
                return parent;
            }
            return parent + "." + child;
        }
    }

    public static class CollectionData<R, V>
    extends ObjectData<R, V> {
    }

    public static class LocalTimeData<R>
    extends ObjectData<R, LocalTime> {
    }

    public static class LocalDateData<R>
    extends ObjectData<R, LocalDate> {
    }

    public static class DateData<R>
    extends ObjectData<R, Date> {
    }

    public static class StringData<R>
    extends ObjectData<R, String> {
    }

    public static class NumberData<R, V extends Number>
    extends BaseData<R, V> {
    }

    public static class IntData<R>
    extends BaseData<R, Integer> {
    }

    public static class ObjectData<R, V>
    extends BaseData<R, V> {
    }

    public static class RootData<R>
    extends ObjectData<R, R> {
    }

    public static class BaseData<R, V>
    implements FluentValidatorValidationData<R, V> {
        private List<FluentValidatorRule<R, V>> rules = new ArrayList<FluentValidatorRule<R, V>>();
        private List<BiFunction> when = new ArrayList<BiFunction>();
        private Function mapFrom;
        private Fv.Validator<V> validator;
        private final List<CustomValidator> customValidators = new ArrayList<CustomValidator>();

        public void addWhen(BiFunction<?, V, Boolean> when) {
            this.when.add(when);
        }

        public <P> void addWhen(Function<P, Boolean> when) {
            this.when.add((p, v) -> (Boolean)when.apply(p));
        }

        public void addRule(FluentValidatorRule<R, V> rule) {
            this.rules.add(rule);
        }

        public void addCustom(CustomValidator FluentValidatorCustom) {
            this.customValidators.add(FluentValidatorCustom);
        }

        @Override
        public Fv.Result validate(R rootObject, String property, V value) {
            if (this.mapFrom != null && value != null) {
                value = this.mapFrom.apply(value);
            }
            for (BiFunction biFunction : this.when) {
                if (((Boolean)biFunction.apply(rootObject, value)).booleanValue()) continue;
                return null;
            }
            for (FluentValidatorRule fluentValidatorRule : this.rules) {
                Fv.Result result = fluentValidatorRule.validate(rootObject, property, value);
                if (result == null || !result.hasErrors()) continue;
                return result;
            }
            return null;
        }

        public List<FluentValidatorRule<R, V>> getRules() {
            return this.rules;
        }

        public List<BiFunction> getWhen() {
            return this.when;
        }

        public Function getMapFrom() {
            return this.mapFrom;
        }

        public Fv.Validator<V> getValidator() {
            return this.validator;
        }

        public List<CustomValidator> getCustomValidators() {
            return this.customValidators;
        }

        public void setRules(List<FluentValidatorRule<R, V>> rules) {
            this.rules = rules;
        }

        public void setWhen(List<BiFunction> when) {
            this.when = when;
        }

        public void setMapFrom(Function mapFrom) {
            this.mapFrom = mapFrom;
        }

        public void setValidator(Fv.Validator<V> validator) {
            this.validator = validator;
        }
    }

    public static interface FluentValidatorValidationData<R, V> {
        public Fv.Result validate(R var1, String var2, V var3);
    }

    public static interface CustomValidator {

        public static interface WithBuilder<P, V>
        extends CustomValidator {
            public Fv.CustomResult validate(P var1, V var2, FluentValidatorBuilder<V> var3);
        }

        public static interface Simple<P, V>
        extends CustomValidator {
            public Fv.CustomResult validate(P var1, V var2);
        }
    }

    public static class BaseBuilder<R, V, BuilderClass, DataClass extends BaseData<R, V>> {
        protected DataClass data;

        public BaseBuilder(DataClass data) {
            this.data = data;
        }

        public BuilderClass eq(V value) {
            ((BaseData)this.data).addRule(new FluentValidatorRule.Base.Eq(value));
            return this._this();
        }

        public BuilderClass eq(Function<V, Boolean> eqFunction) {
            ((BaseData)this.data).addRule(new FluentValidatorRule.Base.EqFunction(eqFunction));
            return this._this();
        }

        public BuilderClass notEq(V value) {
            ((BaseData)this.data).addRule(new FluentValidatorRule.Base.NotEq(value));
            return this._this();
        }

        public BuilderClass notEq(Function<V, Boolean> notEqFunction) {
            ((BaseData)this.data).addRule(new FluentValidatorRule.Base.NotEqFunction(notEqFunction));
            return this._this();
        }

        public BuilderClass when(BiFunction<R, V, Boolean> when) {
            ((BaseData)this.data).addWhen(when);
            return this._this();
        }

        public BuilderClass when(Function<R, Boolean> when) {
            ((BaseData)this.data).addWhen(when);
            return this._this();
        }

        public <S> BuilderClass mapFrom(Class<S> clazz, Function<S, V> mapFrom) {
            ((BaseData)this.data).setMapFrom(mapFrom);
            return this._this();
        }

        public BuilderClass validator(Fv.Validator<V> validator) {
            ((BaseData)this.data).addRule(new FluentValidatorRule.Base.Validator(validator));
            return this._this();
        }

        public BuilderClass custom(CustomValidator.Simple<R, V> fluentValidatorCustom) {
            ((BaseData)this.data).addRule(new FluentValidatorRule.Base.Custom<R, V>(fluentValidatorCustom));
            return this._this();
        }

        public BuilderClass customWithBuilder(CustomValidator.WithBuilder<R, V> customValidatorWithBuilder) {
            ((BaseData)this.data).addRule(new FluentValidatorRule.Base.Custom<R, V>(customValidatorWithBuilder));
            return this._this();
        }

        protected BuilderClass _this() {
            return (BuilderClass)this;
        }
    }
}

