/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.validator;

import io.thedocs.soyuz.validator.FluentValidatorImpl;
import io.thedocs.soyuz.validator.FluentValidatorObjects;
import io.thedocs.soyuz.validator.FluentValidatorRule;
import io.thedocs.soyuz.validator.Fv;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class FluentValidatorBuilder<T> {
    private String rootProperty;
    private List<ValidationDataWithProperties> validationData = new ArrayList<ValidationDataWithProperties>();

    public FluentValidatorBuilder() {
        this(null);
    }

    public FluentValidatorBuilder(String rootProperty) {
        this.rootProperty = rootProperty;
    }

    public RootBuilder<T> self() {
        return new RootBuilder(this);
    }

    public ObjectBuilder<T, Object> object(String property) {
        return new ObjectBuilder(this, this.getFullProperty(property));
    }

    public <V> ObjectBuilder<T, V> object(String property, Class<V> clazz) {
        return new ObjectBuilder(this, this.getFullProperty(property));
    }

    public StringBuilder<T> string(String property) {
        return new StringBuilder(this, this.getFullProperty(property));
    }

    public DateBuilder<T> date(String property) {
        return new DateBuilder(this, this.getFullProperty(property));
    }

    public LocalDateBuilder<T> localDate(String property) {
        return new LocalDateBuilder(this, this.getFullProperty(property));
    }

    public LocalTimeBuilder<T> localTime(String property) {
        return new LocalTimeBuilder(this, this.getFullProperty(property));
    }

    public CollectionBuilder<T, Object> collection(String property) {
        return new CollectionBuilder(this, this.getFullProperty(property));
    }

    public <V> CollectionBuilder<T, V> collection(String property, Class<V> clazz) {
        return new CollectionBuilder(this, this.getFullProperty(property));
    }

    public PrimitiveIntBuilder<T> primitiveInt(String property) {
        return new PrimitiveIntBuilder(this, this.getFullProperty(property));
    }

    public IntegerBuilder<T> integer(String property) {
        return new IntegerBuilder(this, this.getFullProperty(property));
    }

    public DoubleBuilder<T> double_(String property) {
        return new DoubleBuilder(this, this.getFullProperty(property));
    }

    public LongBuilder<T> long_(String property) {
        return new LongBuilder(this, this.getFullProperty(property));
    }

    public Fv.Validator<T> build() {
        return new FluentValidatorImpl(this.validationData);
    }

    private FluentValidatorBuilder<T> addFluentValidatorValidationData(String property, FluentValidatorObjects.FluentValidatorValidationData validationData) {
        this.validationData.add(new ValidationDataWithProperties(property, validationData));
        return this;
    }

    private String getFullProperty(String property) {
        if (this.rootProperty == null) {
            return property;
        }
        return this.rootProperty + "." + property;
    }

    private static <V extends Comparable> Comparator<V> getComparableComparator() {
        return (o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        };
    }

    public static class ValidationDataWithProperties {
        private String property;
        private FluentValidatorObjects.FluentValidatorValidationData data;

        public ValidationDataWithProperties(String property, FluentValidatorObjects.FluentValidatorValidationData data) {
            this.property = property;
            this.data = data;
        }

        @Nullable
        public String getProperty() {
            return this.property;
        }

        public FluentValidatorObjects.FluentValidatorValidationData getData() {
            return this.data;
        }

        public String toString() {
            return "FluentValidatorBuilder.ValidationDataWithProperties(property=" + this.getProperty() + ", data=" + this.getData() + ")";
        }
    }

    private static abstract class AbstractBuilder<R, V, BuilderClass, DataClass extends FluentValidatorObjects.BaseData<R, V>>
    extends FluentValidatorObjects.BaseBuilder<R, V, BuilderClass, DataClass> {
        protected FluentValidatorBuilder<R> builder;
        protected String property;

        public AbstractBuilder(FluentValidatorBuilder<R> builder, DataClass data, String property) {
            super(data);
            this.builder = builder;
            this.property = property;
        }

        public FluentValidatorBuilder<R> b() {
            return ((FluentValidatorBuilder)this.builder).addFluentValidatorValidationData(this.property, this.data);
        }

        public FluentValidatorBuilder<R> and() {
            return this.b();
        }
    }

    private static abstract class AbstractObjectBuilder<R, V, BuilderClass, DataClass extends FluentValidatorObjects.BaseData<R, V>>
    extends AbstractBuilder<R, V, BuilderClass, DataClass> {
        public AbstractObjectBuilder(FluentValidatorBuilder<R> builder, DataClass data, String property) {
            super(builder, data, property);
        }

        public BuilderClass notNull() {
            this.data.addRule(new FluentValidatorRule.Obj.NotNull());
            return this._this();
        }
    }

    private static class AbstractNumberBuilder<R, V extends Number, BuilderClass, DataClass extends FluentValidatorObjects.BaseData<R, V>>
    extends AbstractObjectBuilder<R, V, BuilderClass, DataClass> {
        public AbstractNumberBuilder(FluentValidatorBuilder<R> builder, DataClass data, String property) {
            super(builder, data, property);
        }

        public BuilderClass greaterOrEqual(V value) {
            this.data.addRule(new FluentValidatorRule.N.GreaterOrEqual(value));
            return this._this();
        }

        public BuilderClass greaterThan(V value) {
            this.data.addRule(new FluentValidatorRule.N.GreaterThan(value));
            return this._this();
        }

        public BuilderClass lessOrEqual(V value) {
            this.data.addRule(new FluentValidatorRule.N.LessOrEqual(value));
            return this._this();
        }

        public BuilderClass lessThan(V value) {
            this.data.addRule(new FluentValidatorRule.N.LessThan(value));
            return this._this();
        }
    }

    public static class ObjectBuilder<R, V>
    extends AbstractObjectBuilder<R, V, ObjectBuilder<R, V>, FluentValidatorObjects.ObjectData<R, V>> {
        public ObjectBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.ObjectData(), property);
        }
    }

    public static class CollectionBuilder<R, V>
    extends AbstractObjectBuilder<R, Collection<V>, CollectionBuilder<R, V>, FluentValidatorObjects.CollectionData<R, Collection<V>>> {
        public CollectionBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.CollectionData(), property);
        }

        public CollectionBuilder<R, V> notEmpty() {
            ((FluentValidatorObjects.CollectionData)this.data).addRule(new FluentValidatorRule.Coll.NotEmpty());
            return this;
        }

        public CollectionBuilder<R, V> greaterOrEqual(int size) {
            ((FluentValidatorObjects.CollectionData)this.data).addRule(new FluentValidatorRule.Coll.GreaterOrEqual(size));
            return this;
        }

        public CollectionBuilder<R, V> greaterThan(int size) {
            ((FluentValidatorObjects.CollectionData)this.data).addRule(new FluentValidatorRule.Coll.GreaterThan(size));
            return this;
        }

        public CollectionBuilder<R, V> lessOrEqual(int size) {
            ((FluentValidatorObjects.CollectionData)this.data).addRule(new FluentValidatorRule.Coll.LessOrEqual(size));
            return this;
        }

        public CollectionBuilder<R, V> lessThan(int size) {
            ((FluentValidatorObjects.CollectionData)this.data).addRule(new FluentValidatorRule.Coll.LessThan(size));
            return this;
        }

        public CollectionBuilder<R, V> itemValidator(Fv.Validator<V> validator) {
            ((FluentValidatorObjects.CollectionData)this.data).addRule(new FluentValidatorRule.Coll.ItemValidator(validator));
            return (CollectionBuilder)this._this();
        }
    }

    public static abstract class AbstractDateBuilder<R, V, BuilderClass, DataClass extends FluentValidatorObjects.BaseData<R, V>>
    extends AbstractObjectBuilder<R, V, BuilderClass, DataClass> {
        private Comparator<V> comparator;

        public AbstractDateBuilder(FluentValidatorBuilder<R> builder, DataClass data, String property, Comparator<V> comparator) {
            super(builder, data, property);
            this.comparator = comparator;
        }

        public BuilderClass lessThan(V date) {
            return this.lessThan(() -> date);
        }

        public BuilderClass lessThan(Supplier<V> dateSupplier) {
            this.data.addRule(new FluentValidatorRule.D.LessThan(dateSupplier, this.comparator));
            return this._this();
        }

        public BuilderClass lessOrEqual(V date) {
            return this.lessOrEqual(() -> date);
        }

        public BuilderClass lessOrEqual(Supplier<V> dateSupplier) {
            this.data.addRule(new FluentValidatorRule.D.LessOrEqual(dateSupplier, this.comparator));
            return this._this();
        }

        public BuilderClass greaterThan(V date) {
            return this.greaterThan(() -> date);
        }

        public BuilderClass greaterThan(Supplier<V> dateSupplier) {
            this.data.addRule(new FluentValidatorRule.D.GreaterThan(dateSupplier, this.comparator));
            return this._this();
        }

        public BuilderClass greaterOrEqual(V date) {
            return this.greaterOrEqual(() -> date);
        }

        public BuilderClass greaterOrEqual(Supplier<V> dateSupplier) {
            this.data.addRule(new FluentValidatorRule.D.GreaterOrEqual(dateSupplier, this.comparator));
            return this._this();
        }

        public BuilderClass between(V after, V before) {
            return this.between(() -> after, () -> before);
        }

        public BuilderClass between(Supplier<V> afterSupplier, Supplier<V> beforeSupplier) {
            this.data.addRule(new FluentValidatorRule.D.Between(afterSupplier, beforeSupplier, this.comparator));
            return this._this();
        }
    }

    public static class LocalTimeBuilder<R>
    extends AbstractDateBuilder<R, LocalTime, LocalTimeBuilder<R>, FluentValidatorObjects.LocalTimeData<R>> {
        public LocalTimeBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.LocalTimeData(), property, FluentValidatorBuilder.getComparableComparator());
        }
    }

    public static class LocalDateBuilder<R>
    extends AbstractDateBuilder<R, LocalDate, LocalDateBuilder<R>, FluentValidatorObjects.LocalDateData<R>> {
        public LocalDateBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.LocalDateData(), property, FluentValidatorBuilder.getComparableComparator());
        }
    }

    public static class DateBuilder<R>
    extends AbstractDateBuilder<R, Date, DateBuilder<R>, FluentValidatorObjects.DateData<R>> {
        public DateBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.DateData(), property, FluentValidatorBuilder.getComparableComparator());
        }
    }

    public static class StringBuilder<R>
    extends AbstractObjectBuilder<R, String, StringBuilder<R>, FluentValidatorObjects.StringData<R>> {
        public StringBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.StringData(), property);
        }

        public StringBuilder<R> url() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.Url());
            return this;
        }

        public StringBuilder<R> email() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.Email());
            return this;
        }

        public StringBuilder<R> notEmpty() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.NotEmpty());
            return this;
        }

        public StringBuilder<R> notBlank() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.NotBlank());
            return this;
        }

        public StringBuilder<R> isBoolean() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.IsBoolean());
            return this;
        }

        public StringBuilder<R> isByte() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.IsByte());
            return this;
        }

        public StringBuilder<R> isShort() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.IsShort());
            return this;
        }

        public StringBuilder<R> isInteger() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.IsInteger());
            return this;
        }

        public StringBuilder<R> isLong() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.IsLong());
            return this;
        }

        public StringBuilder<R> isFloat() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.IsFloat());
            return this;
        }

        public StringBuilder<R> isDouble() {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.IsDouble());
            return this;
        }

        public StringBuilder<R> greaterOrEqual(int size) {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.GreaterOrEqual(size));
            return this;
        }

        public StringBuilder<R> greaterThan(int size) {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.GreaterThan(size));
            return this;
        }

        public StringBuilder<R> lessOrEqual(int size) {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.LessOrEqual(size));
            return this;
        }

        public StringBuilder<R> lessThan(int size) {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.LessThan(size));
            return this;
        }

        public StringBuilder<R> matches(Pattern pattern) {
            ((FluentValidatorObjects.StringData)this.data).addRule(new FluentValidatorRule.Str.Matches(pattern));
            return this;
        }
    }

    public static class RootBuilder<R>
    extends AbstractObjectBuilder<R, R, RootBuilder<R>, FluentValidatorObjects.RootData<R>> {
        public RootBuilder(FluentValidatorBuilder<R> builder) {
            super(builder, new FluentValidatorObjects.RootData(), null);
        }

        public ObjectBuilder<R, Object> object() {
            return new ObjectBuilder(this.builder, null);
        }

        public <V> ObjectBuilder<R, V> object(Class<V> clazz) {
            return new ObjectBuilder(this.builder, null);
        }

        public StringBuilder<R> string() {
            return new StringBuilder(this.builder, null);
        }

        public DateBuilder<R> date() {
            return new DateBuilder(this.builder, null);
        }

        public LocalDateBuilder<R> localDate() {
            return new LocalDateBuilder(this.builder, null);
        }

        public LocalTimeBuilder<R> localTime() {
            return new LocalTimeBuilder(this.builder, null);
        }

        public CollectionBuilder<R, Object> collection() {
            return new CollectionBuilder(this.builder, null);
        }

        public <V> CollectionBuilder<R, V> collection(Class<V> clazz) {
            return new CollectionBuilder(this.builder, null);
        }

        public PrimitiveIntBuilder<R> primitiveInt() {
            return new PrimitiveIntBuilder(this.builder, null);
        }

        public IntegerBuilder<R> integer() {
            return new IntegerBuilder(this.builder, null);
        }

        public DoubleBuilder<R> double_() {
            return new DoubleBuilder(this.builder, null);
        }

        public LongBuilder<R> long_() {
            return new LongBuilder(this.builder, null);
        }
    }

    public static class DoubleBuilder<R>
    extends AbstractNumberBuilder<R, Double, DoubleBuilder<R>, FluentValidatorObjects.NumberData<R, Double>> {
        public DoubleBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.NumberData(), property);
        }
    }

    public static class LongBuilder<R>
    extends AbstractNumberBuilder<R, Long, IntegerBuilder<R>, FluentValidatorObjects.NumberData<R, Long>> {
        public LongBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.NumberData(), property);
        }
    }

    public static class IntegerBuilder<R>
    extends AbstractNumberBuilder<R, Integer, IntegerBuilder<R>, FluentValidatorObjects.NumberData<R, Integer>> {
        public IntegerBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.NumberData(), property);
        }
    }

    public static class PrimitiveIntBuilder<R>
    extends AbstractBuilder<R, Integer, PrimitiveIntBuilder<R>, FluentValidatorObjects.IntData<R>> {
        public PrimitiveIntBuilder(FluentValidatorBuilder<R> builder, String property) {
            super(builder, new FluentValidatorObjects.IntData(), property);
        }

        public PrimitiveIntBuilder<R> greaterOrEqual(int value) {
            ((FluentValidatorObjects.IntData)this.data).addRule(new FluentValidatorRule.Int.GreaterOrEqual(value));
            return this;
        }

        public PrimitiveIntBuilder<R> greaterThan(int value) {
            ((FluentValidatorObjects.IntData)this.data).addRule(new FluentValidatorRule.Int.GreaterThan(value));
            return this;
        }

        public PrimitiveIntBuilder<R> lessOrEqual(int value) {
            ((FluentValidatorObjects.IntData)this.data).addRule(new FluentValidatorRule.Int.LessOrEqual(value));
            return this;
        }

        public PrimitiveIntBuilder<R> lessThan(int value) {
            ((FluentValidatorObjects.IntData)this.data).addRule(new FluentValidatorRule.Int.LessThan(value));
            return this;
        }
    }
}

