/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.domain;

import com.fasterxml.jackson.annotation.JsonValue;
import io.thedocs.soyuz.TruthyCastableI;
import io.thedocs.soyuz.is;
import io.thedocs.soyuz.to;
import java.util.UUID;

public interface Wrapper {

    public static abstract class Int
    implements TruthyCastableI {
        protected int value;

        public Int(String value) {
            this.value = to.Integer((String)value);
        }

        @JsonValue
        public int asInt() {
            return this.value;
        }

        public String toString() {
            return to.s((int)this.value);
        }

        public boolean asTruthy() {
            return this.value != 0;
        }

        public Int(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Int)) {
                return false;
            }
            Int other = (Int)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.value == other.value;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Int;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.value;
            return result;
        }

        public Int() {
        }
    }

    public static abstract class Long
    implements TruthyCastableI {
        protected long id;

        public Long(String id) {
            this.id = to.Long((String)id);
        }

        @JsonValue
        public long asLong() {
            return this.id;
        }

        public String toString() {
            return to.s((long)this.id);
        }

        public boolean asTruthy() {
            return this.id != 0L;
        }

        public Long(long id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Long)) {
                return false;
            }
            Long other = (Long)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.id == other.id;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Long;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.id;
            result = result * 59 + (int)($id >>> 32 ^ $id);
            return result;
        }

        public Long() {
        }
    }

    public static abstract class StrLowerCase
    extends Str {
        public StrLowerCase() {
        }

        public StrLowerCase(String id) {
            super((String)to.nullOr((Object)id, String::toLowerCase));
        }
    }

    public static abstract class Str
    implements TruthyCastableI {
        protected String id;

        public Str(String id) {
            this.id = id;
        }

        @JsonValue
        public String asString() {
            return this.id;
        }

        public String toString() {
            return to.s((Object)this.id);
        }

        public boolean asTruthy() {
            return is.t((String)this.id);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Str)) {
                return false;
            }
            Str other = (Str)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.id;
            String other$id = other.id;
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Str;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.id;
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public Str() {
        }
    }

    public static abstract class Uuid
    implements TruthyCastableI {
        protected UUID id;

        public Uuid(String id) {
            this.id = UUID.fromString(id);
        }

        @JsonValue
        public String asString() {
            return (String)to.nullOr((Object)this.id, UUID::toString);
        }

        public UUID asUuid() {
            return this.id;
        }

        public String toString() {
            return to.s((Object)this.id);
        }

        public boolean asTruthy() {
            return this.id != null;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Uuid)) {
                return false;
            }
            Uuid other = (Uuid)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.id;
            UUID other$id = other.id;
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Uuid;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.id;
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Uuid() {
        }

        public Uuid(UUID id) {
            this.id = id;
        }
    }
}

