/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.thucydides.core.PendingStepException;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.FailureAnalysis;
import net.thucydides.core.model.FailureCause;
import net.thucydides.core.model.ScreenshotPermission;
import net.thucydides.core.model.Stories;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.pages.SystemClock;
import net.thucydides.core.screenshots.BlurLevel;
import net.thucydides.core.screenshots.Photographer;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.screenshots.ScreenshotBlurCheck;
import net.thucydides.core.screenshots.ScreenshotException;
import net.thucydides.core.screenshots.ScreenshotProcessor;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.SatisfyAnnotatedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SatisfyBaseStepListener
extends BaseStepListener {
    private final List<TestOutcome> testOutcomes;
    private final Stack<TestStep> currentStepStack;
    private final Stack<TestStep> currentGroupStack;
    private StepEventBus eventBus;
    private final SystemClock clock;
    private ScreenshotPermission screenshots;
    private Class<?> testSuite;
    private static final Logger LOGGER = LoggerFactory.getLogger(SatisfyBaseStepListener.class);
    private WebDriver driver;
    private WebdriverManager webdriverManager;
    private File outputDirectory;
    private WebdriverProxyFactory proxyFactory;
    private Story testedStory;
    private Configuration configuration;
    ScreenshotProcessor screenshotProcessor;
    private boolean inFluentStepSequence;
    private List<String> storywideIssues;
    private List<TestTag> storywideTags;
    private boolean suiteStarted = false;
    FailureAnalysis failureAnalysis = new FailureAnalysis();
    int currentExample = 0;

    public void setEventBus(StepEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public StepEventBus getEventBus() {
        if (this.eventBus == null) {
            this.eventBus = StepEventBus.getEventBus();
        }
        return this.eventBus;
    }

    public Optional<TestStep> cloneCurrentStep() {
        return this.currentStepExists() ? this.getCurrentStep().clone() : Optional.absent();
    }

    public void setAllStepsTo(TestResult result) {
        this.getCurrentTestOutcome().setAnnotatedResult(result);
        this.getCurrentTestOutcome().setAllStepsTo(result);
    }

    public SatisfyBaseStepListener(File outputDirectory) {
        this(outputDirectory, Injectors.getInjector());
    }

    public SatisfyBaseStepListener(File outputDirectory, Injector injector) {
        super(outputDirectory, injector);
        this.proxyFactory = WebdriverProxyFactory.getFactory();
        this.testOutcomes = Lists.newArrayList();
        this.currentStepStack = new Stack();
        this.currentGroupStack = new Stack();
        this.outputDirectory = outputDirectory;
        this.inFluentStepSequence = false;
        this.storywideIssues = Lists.newArrayList();
        this.storywideTags = Lists.newArrayList();
        this.webdriverManager = (WebdriverManager)injector.getInstance(WebdriverManager.class);
        this.clock = (SystemClock)injector.getInstance(SystemClock.class);
        this.configuration = (Configuration)injector.getInstance(Configuration.class);
        this.screenshotProcessor = (ScreenshotProcessor)injector.getInstance(ScreenshotProcessor.class);
    }

    public SatisfyBaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory) {
        this(outputDirectory);
        this.driver = this.getProxyFactory().proxyFor(driverClass);
    }

    public SatisfyBaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory, Configuration configuration) {
        this(outputDirectory);
        this.driver = this.getProxyFactory().proxyFor(driverClass);
        this.configuration = configuration;
    }

    public SatisfyBaseStepListener(File outputDirectory, WebdriverManager webdriverManager) {
        this(outputDirectory);
        this.webdriverManager = webdriverManager;
    }

    public SatisfyBaseStepListener(File outputDirectory, Pages pages) {
        this(outputDirectory);
        if (pages != null) {
            this.setDriverUsingPagesDriverIfDefined(pages);
        } else {
            this.createNewDriver();
        }
    }

    protected ScreenshotPermission screenshots() {
        if (this.screenshots == null) {
            this.screenshots = new ScreenshotPermission(this.configuration);
        }
        return this.screenshots;
    }

    private void createNewDriver() {
        this.setDriver(this.getProxyFactory().proxyDriver());
    }

    private void setDriverUsingPagesDriverIfDefined(Pages pages) {
        if (pages.getDriver() != null) {
            this.setDriver(pages.getDriver());
        } else {
            this.createNewDriver();
            pages.setDriver(this.getDriver());
        }
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected TestOutcome getCurrentTestOutcome() {
        Preconditions.checkState((!this.testOutcomes.isEmpty() ? 1 : 0) != 0);
        return this.testOutcomes.get(this.testOutcomes.size() - 1);
    }

    protected SystemClock getClock() {
        return this.clock;
    }

    public void testSuiteStarted(Class<?> startedTestSuite) {
        this.testSuite = startedTestSuite;
        this.testedStory = Stories.findStoryFrom(startedTestSuite);
        this.clearStorywideTagsAndIssues();
    }

    private void clearStorywideTagsAndIssues() {
        this.storywideIssues.clear();
        this.storywideTags.clear();
    }

    public void testSuiteStarted(Story story) {
        this.testSuite = null;
        this.testedStory = story;
        this.suiteStarted = true;
        this.clearStorywideTagsAndIssues();
    }

    public boolean testSuiteRunning() {
        return this.suiteStarted;
    }

    public void addIssuesToCurrentStory(List<String> issues) {
        this.storywideIssues.addAll(issues);
    }

    public void addTagsToCurrentStory(List<TestTag> tags) {
        this.storywideTags.addAll(tags);
    }

    public void testSuiteFinished() {
        this.screenshotProcessor.waitUntilDone();
        this.clearStorywideTagsAndIssues();
        this.suiteStarted = false;
    }

    public void testStarted(String testMethod) {
        TestOutcome newTestOutcome = TestOutcome.forTestInStory((String)testMethod, this.testSuite, (Story)this.testedStory);
        this.testOutcomes.add(newTestOutcome);
        this.updateSessionIdIfKnown();
        this.setAnnotatedResult(testMethod);
    }

    private void updateSessionIdIfKnown() {
        SessionId sessionId = this.webdriverManager.getSessionId();
        if (sessionId != null) {
            this.getCurrentTestOutcome().setSessionId(sessionId.toString());
        }
    }

    public void updateCurrentStepTitle(String updatedStepTitle) {
        if (this.currentStepExists()) {
            this.getCurrentStep().setDescription(updatedStepTitle);
        } else {
            this.stepStarted(ExecutedStepDescription.withTitle((String)updatedStepTitle));
        }
    }

    private void setAnnotatedResult(String testMethod) {
        if (TestAnnotations.forClass(this.testSuite).isIgnored(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
        }
        if (TestAnnotations.forClass(this.testSuite).isPending(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.PENDING);
        }
    }

    public void testFinished(TestOutcome outcome) {
        this.recordTestDuration();
        this.getCurrentTestOutcome().addIssues(this.storywideIssues);
        this.getCurrentTestOutcome().addTags(this.storywideTags);
        this.currentStepStack.clear();
    }

    public void testRetried() {
        this.currentStepStack.clear();
        this.testOutcomes.remove(this.getCurrentTestOutcome());
    }

    private void recordTestDuration() {
        if (!this.testOutcomes.isEmpty()) {
            this.getCurrentTestOutcome().recordDuration();
        }
    }

    public void stepStarted(ExecutedStepDescription description) {
        this.recordStep(description);
        this.takeInitialScreenshot();
        this.updateSessionIdIfKnown();
    }

    public void skippedStepStarted(ExecutedStepDescription description) {
        this.recordStep(description);
    }

    private void recordStep(ExecutedStepDescription description) {
        String stepName = SatisfyAnnotatedStepDescription.from(description).getName();
        this.updateFluentStepStatus(description, stepName);
        if (this.justStartedAFluentSequenceFor(description) || this.notInAFluentSequence()) {
            TestStep step = new TestStep(stepName);
            this.startNewGroupIfNested();
            this.setDefaultResultFromAnnotations(step, description);
            this.currentStepStack.push(step);
            this.recordStepToCurrentTestOutcome(step);
        }
        this.inFluentStepSequence = SatisfyAnnotatedStepDescription.from(description).isFluent();
    }

    private void recordStepToCurrentTestOutcome(TestStep step) {
        this.getCurrentTestOutcome().recordStep(step);
    }

    private void updateFluentStepStatus(ExecutedStepDescription description, String stepName) {
        if (this.currentlyInAFluentSequenceFor(description) || this.justFinishedAFluentSequenceFor(description)) {
            this.addToFluentStepName(stepName);
        }
    }

    private void addToFluentStepName(String stepName) {
        String updatedStepName = this.getCurrentStep().getDescription() + " " + StringUtils.uncapitalize((String)stepName);
        this.getCurrentStep().setDescription(updatedStepName);
    }

    private boolean notInAFluentSequence() {
        return !this.inFluentStepSequence;
    }

    private boolean justFinishedAFluentSequenceFor(ExecutedStepDescription description) {
        boolean thisStepIsFluent = SatisfyAnnotatedStepDescription.from(description).isFluent();
        return this.inFluentStepSequence && !thisStepIsFluent;
    }

    private boolean justStartedAFluentSequenceFor(ExecutedStepDescription description) {
        boolean thisStepIsFluent = SatisfyAnnotatedStepDescription.from(description).isFluent();
        return !this.inFluentStepSequence && thisStepIsFluent;
    }

    private boolean currentlyInAFluentSequenceFor(ExecutedStepDescription description) {
        boolean thisStepIsFluent = SatisfyAnnotatedStepDescription.from(description).isFluent();
        return this.inFluentStepSequence && thisStepIsFluent;
    }

    private void setDefaultResultFromAnnotations(TestStep step, ExecutedStepDescription description) {
        if (TestAnnotations.isPending((Method)description.getTestMethod())) {
            step.setResult(TestResult.PENDING);
        }
        if (TestAnnotations.isIgnored((Method)description.getTestMethod())) {
            step.setResult(TestResult.IGNORED);
        }
    }

    private void startNewGroupIfNested() {
        if (this.thereAreUnfinishedSteps() && this.getCurrentStep() != this.getCurrentGroup()) {
            this.startNewGroup();
        }
    }

    private void startNewGroup() {
        this.getCurrentTestOutcome().startGroup();
        this.currentGroupStack.push(this.getCurrentStep());
    }

    private TestStep getCurrentStep() {
        return this.currentStepStack.peek();
    }

    private Optional<TestStep> getPreviousStep() {
        if (this.getCurrentTestOutcome().getTestSteps().size() > 1) {
            List currentTestSteps = this.getCurrentTestOutcome().getTestSteps();
            return Optional.of(currentTestSteps.get(currentTestSteps.size() - 2));
        }
        return Optional.absent();
    }

    private TestStep getCurrentGroup() {
        if (this.currentGroupStack.isEmpty()) {
            return null;
        }
        return this.currentGroupStack.peek();
    }

    private boolean thereAreUnfinishedSteps() {
        return !this.currentStepStack.isEmpty();
    }

    public void stepFinished() {
        this.updateSessionIdIfKnown();
        this.takeEndOfStepScreenshotFor(TestResult.SUCCESS);
        this.currentStepDone(TestResult.SUCCESS);
        this.pauseIfRequired();
    }

    private void updateExampleTableIfNecessary(TestResult result) {
        if (this.getCurrentTestOutcome().isDataDriven()) {
            this.getCurrentTestOutcome().updateCurrentRowResult(result);
        }
    }

    private void finishGroup() {
        this.currentGroupStack.pop();
        this.getCurrentTestOutcome().endGroup();
    }

    private void pauseIfRequired() {
        int delay = this.configuration.getStepDelay();
        if (delay > 0) {
            this.getClock().pauseFor((long)delay);
        }
    }

    private void markCurrentStepAs(TestResult result) {
        this.getCurrentTestOutcome().currentStep().setResult(result);
        this.updateExampleTableIfNecessary(result);
    }

    public void stepFailed(StepFailure failure) {
        this.takeEndOfStepScreenshotFor(TestResult.FAILURE);
        this.getCurrentTestOutcome().determineTestFailureCause(failure.getException());
        this.recordFailureDetailsInFailingTestStep(failure);
        this.currentStepDone(this.failureAnalysis.resultFor(failure));
    }

    public void lastStepFailed(StepFailure failure) {
        this.takeEndOfStepScreenshotFor(TestResult.FAILURE);
        this.getCurrentTestOutcome().lastStepFailedWith(failure);
    }

    private void recordFailureDetailsInFailingTestStep(StepFailure failure) {
        if (this.currentStepExists()) {
            this.getCurrentStep().failedWith((Throwable)new StepFailureException(failure.getMessage(), failure.getException()));
        }
    }

    public void stepIgnored() {
        if (this.aStepHasFailed()) {
            this.markCurrentStepAs(TestResult.SKIPPED);
            this.currentStepDone(TestResult.SKIPPED);
        } else {
            this.currentStepDone(TestResult.IGNORED);
        }
    }

    public void stepPending() {
        this.currentStepDone(TestResult.PENDING);
    }

    public void stepPending(String message) {
        this.getCurrentStep().testAborted((Throwable)new PendingStepException(message));
        this.stepPending();
    }

    public void assumptionViolated(String message) {
        if (this.thereAreUnfinishedSteps()) {
            this.getCurrentStep().testAborted((Throwable)new PendingStepException(message));
            this.stepIgnored();
        }
        this.testIgnored();
    }

    private void currentStepDone(TestResult result) {
        if (!this.inFluentStepSequence && this.currentStepExists()) {
            TestStep finishedStep = this.currentStepStack.pop();
            finishedStep.recordDuration();
            if (result != null) {
                finishedStep.setResult(result);
            }
            if (finishedStep == this.getCurrentGroup()) {
                this.finishGroup();
            }
        }
        this.updateExampleTableIfNecessary(result);
    }

    private boolean currentStepExists() {
        return !this.currentStepStack.isEmpty();
    }

    private void takeEndOfStepScreenshotFor(TestResult result) {
        if (this.shouldTakeEndOfStepScreenshotFor(result)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    private void take(ScreenshotType screenshotType) {
        if (this.currentStepExists() && this.browserIsOpen()) {
            try {
                Optional<ScreenshotAndHtmlSource> screenshotAndHtmlSource = this.grabScreenshot();
                if (screenshotAndHtmlSource.isPresent()) {
                    this.takeScreenshotIfRequired(screenshotType, (ScreenshotAndHtmlSource)screenshotAndHtmlSource.get());
                }
                this.removeDuplicatedInitalScreenshotsIfPresent();
            }
            catch (ScreenshotException e) {
                LOGGER.warn("Failed to take screenshot", (Throwable)e);
            }
        }
    }

    private void removeDuplicatedInitalScreenshotsIfPresent() {
        if (this.currentStepHasMoreThanOneScreenshot() && this.getPreviousStep().isPresent() && ((TestStep)this.getPreviousStep().get()).hasScreenshots()) {
            ScreenshotAndHtmlSource lastScreenshotOfPreviousStep = this.lastScreenshotOf((TestStep)this.getPreviousStep().get());
            ScreenshotAndHtmlSource firstScreenshotOfThisStep = this.getCurrentStep().getFirstScreenshot();
            if (firstScreenshotOfThisStep.hasIdenticalScreenshotsAs(lastScreenshotOfPreviousStep)) {
                this.removeFirstScreenshotOfCurrentStep();
            }
        }
    }

    private void removeFirstScreenshotOfCurrentStep() {
        this.getCurrentStep().removeScreenshot(0);
    }

    private boolean currentStepHasMoreThanOneScreenshot() {
        return this.getCurrentStep().getScreenshotCount() > 1;
    }

    private ScreenshotAndHtmlSource lastScreenshotOf(TestStep testStep) {
        return (ScreenshotAndHtmlSource)testStep.getScreenshots().get(testStep.getScreenshots().size() - 1);
    }

    private void takeScreenshotIfRequired(ScreenshotType screenshotType, ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.shouldTakeScreenshot(screenshotType, screenshotAndHtmlSource) && this.screenshotWasTaken(screenshotAndHtmlSource)) {
            this.getCurrentStep().addScreenshot(screenshotAndHtmlSource);
        }
    }

    private boolean screenshotWasTaken(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotAndHtmlSource.getScreenshotFile() != null;
    }

    private boolean shouldTakeScreenshot(ScreenshotType screenshotType, ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotType == ScreenshotType.MANDATORY_SCREENSHOT || this.getCurrentStep().getScreenshots().isEmpty() || this.shouldTakeOptionalScreenshot(screenshotAndHtmlSource);
    }

    private boolean shouldTakeOptionalScreenshot(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotAndHtmlSource.wasTaken() && this.previousScreenshot().isPresent() && !screenshotAndHtmlSource.hasIdenticalScreenshotsAs((ScreenshotAndHtmlSource)this.previousScreenshot().get());
    }

    private Optional<ScreenshotAndHtmlSource> previousScreenshot() {
        List screenshotsToDate = this.getCurrentTestOutcome().getScreenshotAndHtmlSources();
        if (screenshotsToDate.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(screenshotsToDate.get(screenshotsToDate.size() - 1));
    }

    private boolean browserIsOpen() {
        if (this.driver == null) {
            return false;
        }
        if (this.driver instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.driver).isInstantiated();
        }
        return this.driver.getCurrentUrl() != null;
    }

    private void takeInitialScreenshot() {
        if (this.currentStepExists() && this.screenshots().areAllowed(TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    private Optional<ScreenshotAndHtmlSource> grabScreenshot() {
        Optional screenshot = this.getPhotographer().takeScreenshot();
        if (screenshot.isPresent()) {
            if (this.shouldStoreSourcecode()) {
                File sourcecodeFile = this.sourcecodeForScreenshot((File)screenshot.get(), this.getPageSource());
                return Optional.of((Object)new ScreenshotAndHtmlSource((File)screenshot.get(), sourcecodeFile));
            }
            return Optional.of((Object)new ScreenshotAndHtmlSource((File)screenshot.get()));
        }
        return Optional.absent();
    }

    public String getPageSource() {
        return this.getPhotographer().getPageSource();
    }

    private File sourcecodeForScreenshot(File screenshotFile, String pageSource) {
        File pageSourceFile = new File(screenshotFile.getAbsolutePath() + "" + ".html");
        try {
            Files.write(pageSourceFile.toPath(), pageSource.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write screen source code", (Throwable)e);
        }
        return pageSourceFile;
    }

    private boolean shouldStoreSourcecode() {
        return this.configuration.storeHtmlSourceCode();
    }

    public Photographer getPhotographer() {
        ScreenshotBlurCheck blurCheck = new ScreenshotBlurCheck();
        if (blurCheck.blurLevel().isPresent()) {
            return new Photographer(this.driver, this.outputDirectory, (BlurLevel)blurCheck.blurLevel().get());
        }
        return new Photographer(this.driver, this.outputDirectory);
    }

    private boolean shouldTakeEndOfStepScreenshotFor(TestResult result) {
        if (result == TestResult.FAILURE) {
            return this.screenshots().areAllowed(TakeScreenshots.FOR_FAILURES);
        }
        return this.screenshots().areAllowed(TakeScreenshots.AFTER_EACH_STEP);
    }

    public List<TestOutcome> getTestOutcomes() {
        ArrayList sortedOutcomes = Lists.newArrayList(this.testOutcomes);
        Collections.sort(sortedOutcomes, this.byStartTimeAndName());
        return ImmutableList.copyOf((Collection)sortedOutcomes);
    }

    private Comparator<? super TestOutcome> byStartTimeAndName() {
        return new Comparator<TestOutcome>(){

            @Override
            public int compare(TestOutcome testOutcome1, TestOutcome testOutcome2) {
                String creationTimeAndName1 = testOutcome1.getStartTime().getMillis() + "_" + testOutcome1.getMethodName();
                String creationTimeAndName2 = testOutcome2.getStartTime().getMillis() + "_" + testOutcome2.getMethodName();
                return creationTimeAndName1.compareTo(creationTimeAndName2);
            }
        };
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public boolean aStepHasFailed() {
        return !this.getTestOutcomes().isEmpty() && (this.getCurrentTestOutcome().getResult() == TestResult.FAILURE || this.getCurrentTestOutcome().getResult() == TestResult.ERROR);
    }

    public FailureCause getTestFailureCause() {
        return this.getCurrentTestOutcome().getTestFailureCause();
    }

    public void testFailed(TestOutcome testOutcome, Throwable cause) {
        this.getCurrentTestOutcome().determineTestFailureCause(cause);
    }

    public void testIgnored() {
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
    }

    public void testSkipped() {
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.SKIPPED);
    }

    public void testPending() {
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.PENDING);
    }

    public void notifyScreenChange() {
        if (this.screenshots().areAllowed(TakeScreenshots.FOR_EACH_ACTION)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    public void takeScreenshot() {
        this.take(ScreenshotType.MANDATORY_SCREENSHOT);
    }

    public void useExamplesFrom(DataTable table) {
        this.getCurrentTestOutcome().useExamplesFrom(table);
        this.currentExample = 0;
    }

    public void exampleStarted(Map<String, String> data) {
        if (this.getCurrentTestOutcome().isDataDriven() && !this.getCurrentTestOutcome().dataIsPredefined()) {
            this.getCurrentTestOutcome().addRow(data);
        }
        ++this.currentExample;
        this.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.exampleTitle(this.currentExample, data)));
    }

    private String exampleTitle(int exampleNumber, Map<String, String> data) {
        return String.format("[%s] %s", exampleNumber, data);
    }

    public void exampleFinished() {
        this.currentStepDone(null);
        this.getCurrentTestOutcome().moveToNextRow();
    }

    protected static enum ScreenshotType {
        OPTIONAL_SCREENSHOT,
        MANDATORY_SCREENSHOT;

    }
}

