/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thucydides.core.Thucydides;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionVariablesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionVariablesUtils.class);
    private static final String PROPERTY_FILE_BASE_NAME = "base";

    private SessionVariablesUtils() {
    }

    public static void save(String key, Object value) {
        Thucydides.getCurrentSession().put((Object)key, value);
        LOGGER.info("Session variable " + key + " = " + value + " was saved.");
    }

    public static Object getVariable(String name) {
        return Thucydides.getCurrentSession().get((Object)name);
    }

    public static String substituteVariableByValue(String templateString) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (Object key : Thucydides.getCurrentSession().keySet()) {
            if (!(key instanceof String)) continue;
            vars.put((String)key, Thucydides.getCurrentSession().get(key));
        }
        StrSubstitutor sub = new StrSubstitutor(vars);
        return sub.replace(templateString);
    }

    public static String localize(String text) {
        Pattern pattern = Pattern.compile("^@.*");
        Matcher matcher = pattern.matcher(text);
        if (matcher.matches()) {
            return SessionVariablesUtils.getValueFromLocalePropertyFile(text);
        }
        return text;
    }

    private static String getValueFromLocalePropertyFile(String localeVariableString) {
        Locale currentLocale = Locale.getDefault();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(PROPERTY_FILE_BASE_NAME, currentLocale);
        String propertyName = localeVariableString.substring(1);
        return resourceBundle.getString(propertyName);
    }
}

