/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.satisfy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.SatisfyStepFactory;
import net.thucydides.core.steps.StepFactory;
import org.jbehave.core.annotations.AfterScenario;
import org.jbehave.core.annotations.AfterStories;
import org.jbehave.core.annotations.AfterStory;
import org.jbehave.core.annotations.AsParameterConverter;
import org.jbehave.core.annotations.BeforeScenario;
import org.jbehave.core.annotations.BeforeStories;
import org.jbehave.core.annotations.BeforeStory;
import org.jbehave.core.annotations.Given;
import org.jbehave.core.annotations.Then;
import org.jbehave.core.annotations.When;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.AbstractStepsFactory;
import org.junit.After;
import org.junit.Before;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;

public class ScanningStepsFactory
extends AbstractStepsFactory {
    private final Set<Class<?>> types = new HashSet();
    private final StepFactory stepFactory;
    private String matchingRegex = ".*";
    private String notMatchingRegex = "";

    public ScanningStepsFactory(Configuration configuration, Class<?> root, Pages pages) {
        super(configuration);
        this.types.addAll(this.scanTypes(root.getPackage().getName()));
        this.stepFactory = new SatisfyStepFactory(pages);
    }

    public ScanningStepsFactory matchingNames(String matchingRegex) {
        this.matchingRegex = matchingRegex;
        return this;
    }

    public ScanningStepsFactory notMatchingNames(String notMatchingRegex) {
        this.notMatchingRegex = notMatchingRegex;
        return this;
    }

    private Set<Class<?>> scanTypes(String packageName) {
        Reflections reflections = new Reflections(packageName, new Scanner[]{new MethodAnnotationsScanner()});
        HashSet types = new HashSet();
        types.addAll(this.typesAnnotatedWith(reflections, Given.class));
        types.addAll(this.typesAnnotatedWith(reflections, When.class));
        types.addAll(this.typesAnnotatedWith(reflections, Then.class));
        types.addAll(this.typesAnnotatedWith(reflections, Before.class));
        types.addAll(this.typesAnnotatedWith(reflections, After.class));
        types.addAll(this.typesAnnotatedWith(reflections, BeforeScenario.class));
        types.addAll(this.typesAnnotatedWith(reflections, AfterScenario.class));
        types.addAll(this.typesAnnotatedWith(reflections, BeforeStory.class));
        types.addAll(this.typesAnnotatedWith(reflections, AfterStory.class));
        types.addAll(this.typesAnnotatedWith(reflections, BeforeStories.class));
        types.addAll(this.typesAnnotatedWith(reflections, AfterStories.class));
        types.addAll(this.typesAnnotatedWith(reflections, AsParameterConverter.class));
        return types;
    }

    private Set<Class<?>> typesAnnotatedWith(Reflections reflections, Class<? extends Annotation> annotation) {
        HashSet types = new HashSet();
        Set methodsAnnotatedWith = reflections.getMethodsAnnotatedWith(annotation);
        for (Method method : methodsAnnotatedWith) {
            types.add(method.getDeclaringClass());
        }
        return types;
    }

    protected List<Class<?>> stepsTypes() {
        ArrayList matchingTypes = new ArrayList();
        for (Class<?> type : this.types) {
            String name = type.getName();
            if (!name.matches(this.matchingRegex) || name.matches(this.notMatchingRegex)) continue;
            matchingTypes.add(type);
        }
        return matchingTypes;
    }

    public Object createInstanceOfType(Class<?> type) {
        return this.stepFactory.instantiateNewStepLibraryFor(type);
    }
}

