/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.satisfy;

import java.util.List;
import java.util.Map;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.StoryReporter;

public class SatisfyStoryReporter
implements StoryReporter {
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private boolean isScenarioWithFailure = false;
    private boolean isStoryWithFailure = false;
    private boolean isStoryWithPending = false;

    public void storyNotAllowed(Story story, String filter) {
    }

    public void storyCancelled(Story story, StoryDuration storyDuration) {
    }

    public void beforeStory(Story story, boolean givenStory) {
    }

    public void afterStory(boolean givenStory) {
    }

    public void narrative(Narrative narrative) {
    }

    public void lifecyle(Lifecycle lifecycle) {
    }

    public void scenarioNotAllowed(Scenario scenario, String filter) {
    }

    public void beforeScenario(String scenarioTitle) {
        if (!scenarioTitle.isEmpty()) {
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)("Scenario: " + scenarioTitle)));
        }
    }

    public void scenarioMeta(Meta meta) {
    }

    public void afterScenario() {
        if (this.aStepInScenarioFailed()) {
            StepEventBus.getEventBus().stepIgnored();
        } else if (this.aPreviousStepHasSuspended()) {
            StepEventBus.getEventBus().stepIgnored();
        } else {
            StepEventBus.getEventBus().stepFinished();
        }
    }

    public void givenStories(GivenStories givenStories) {
    }

    public void givenStories(List<String> storyPaths) {
    }

    public void beforeExamples(List<String> steps, ExamplesTable table) {
    }

    public void example(Map<String, String> tableRow) {
    }

    public void afterExamples() {
    }

    public void beforeStep(String stepTitle) {
        if (this.aPreviousStepHasFailed() || this.aPreviousStepHasSuspended()) {
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)stepTitle));
        }
    }

    public void successful(String title) {
        if (this.aPreviousStepHasFailed() || this.aPreviousStepHasSuspended()) {
            StepEventBus.getEventBus().updateCurrentStepTitle(this.normalized(title));
            StepEventBus.getEventBus().stepIgnored();
        }
    }

    public void ignorable(String title) {
        StepEventBus.getEventBus().updateCurrentStepTitle(this.normalized(title));
        StepEventBus.getEventBus().stepIgnored();
    }

    public void pending(String stepTitle) {
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed()) {
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
            StepEventBus.getEventBus().stepIgnored();
        } else {
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
            StepEventBus.getEventBus().stepPending();
        }
    }

    public void notPerformed(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
        StepEventBus.getEventBus().stepIgnored();
    }

    public void failed(String stepTitle, Throwable cause) {
        Throwable rootCause = cause.getCause() != null ? cause.getCause() : cause;
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
        StepEventBus.getEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)), rootCause));
        this.isStoryWithFailure = true;
    }

    public void failedOutcomes(String step, OutcomesTable table) {
    }

    public void restarted(String step, Throwable cause) {
    }

    public void dryRun() {
    }

    public void pendingMethods(List<String> methods) {
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }

    private boolean aPreviousStepHasFailed() {
        boolean aPreviousStepHasFailed = false;
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed()) {
            if (this.isStoryWithFailure) {
                aPreviousStepHasFailed = true;
            } else {
                this.isStoryWithFailure = true;
            }
        }
        return aPreviousStepHasFailed;
    }

    private boolean aPreviousStepHasSuspended() {
        boolean aPreviousStepHasSuspended = false;
        if (StepEventBus.getEventBus().currentTestIsSuspended()) {
            if (this.isStoryWithPending) {
                aPreviousStepHasSuspended = true;
            } else {
                this.isStoryWithPending = true;
            }
        }
        return aPreviousStepHasSuspended;
    }

    private boolean aStepInScenarioFailed() {
        boolean aPreviousStepHasFailed = false;
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed()) {
            if (this.isScenarioWithFailure) {
                aPreviousStepHasFailed = true;
            } else {
                this.isScenarioWithFailure = true;
            }
        }
        return aPreviousStepHasFailed;
    }
}

