/*
 * Decompiled with CFR 0.152.
 */
package io.tapack.satisfy;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jbehave.core.Embeddable;
import org.jbehave.core.io.UnderscoredCamelCaseResolver;

public class SatisfyStoryPathResolver
extends UnderscoredCamelCaseResolver {
    private String s;

    protected String resolveDirectory(Class<? extends Embeddable> embeddableClass) {
        return "stories";
    }

    protected String resolveName(Class<? extends Embeddable> embeddableClass) {
        String name;
        this.s = name = super.resolveName(embeddableClass);
        URL storiesFolder = Thread.currentThread().getContextClassLoader().getResource("stories");
        try {
            final Path start = Paths.get(storiesFolder.toURI());
            Path path = Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().getName().contentEquals(name + "" + ".story")) {
                        SatisfyStoryPathResolver.this.s = start.relativize(file).toString().replaceFirst("\\.story", "");
                        return FileVisitResult.TERMINATE;
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return this.s;
    }
}

