/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql.stored;

import io.syndesis.connector.sql.SqlCommon;
import io.syndesis.connector.sql.stored.SqlStoredCommon;
import io.syndesis.connector.sql.stored.SqlStoredStartConnectorComponent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlStoredStartConnectorComponentTest
extends CamelTestSupport {
    private static Connection connection;
    private static Properties properties;
    private static SqlCommon sqlCommon;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        sqlCommon = new SqlCommon();
        connection = sqlCommon.setupConnection(connection, properties);
        SqlStoredCommon.setupStoredProcedure(connection, properties);
    }

    @AfterClass
    public static void afterClass() throws SQLException {
        sqlCommon.closeConnection(connection);
    }

    @Test
    public void camelConnectorTest() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"{\"c\":60}"});
        mock.assertIsSatisfied();
    }

    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
                this.from("sql-stored-start-connector:DEMO_OUT( OUT INTEGER c)").to("mock:result");
            }
        };
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        SqlStoredStartConnectorComponent component = new SqlStoredStartConnectorComponent();
        component.addOption("user", (Object)properties.getProperty("sql-connector.user"));
        component.addOption("password", (Object)properties.getProperty("sql-connector.password"));
        component.addOption("url", (Object)properties.getProperty("sql-connector.url"));
        context.addComponent("sql-stored-start-connector", (Component)component);
        return context;
    }

    static {
        properties = new Properties();
    }
}

