/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql.stored;

import io.syndesis.connector.sql.DatabaseMetaDataHelper;
import io.syndesis.connector.sql.stored.ColumnMode;
import io.syndesis.connector.sql.stored.StoredProcedureColumn;
import io.syndesis.connector.sql.stored.StoredProcedureMetadata;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.component.extension.MetaDataExtension;
import org.apache.camel.component.extension.metadata.AbstractMetaDataExtension;
import org.apache.camel.component.extension.metadata.DefaultMetaData;

public class SqlStoredConnectorMetaDataExtension
extends AbstractMetaDataExtension {
    public Optional<MetaDataExtension.MetaData> meta(Map<String, Object> properties) {
        Map<String, StoredProcedureMetadata> list = this.getStoredProcedures(properties);
        DefaultMetaData metaData = new DefaultMetaData(null, null, list);
        return Optional.of(metaData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StoredProcedureMetadata getStoredProcedureMetadata(Connection connection, String catalog, String schema, String procedureName) {
        StoredProcedureMetadata storedProcedureMetadata = new StoredProcedureMetadata();
        storedProcedureMetadata.setName(procedureName);
        try {
            DatabaseMetaData meta = connection.getMetaData();
            try (ResultSet columnSet = DatabaseMetaDataHelper.fetchProcedureColumns(meta, catalog, schema, procedureName);){
                ArrayList<StoredProcedureColumn> columnList = new ArrayList<StoredProcedureColumn>();
                while (columnSet.next()) {
                    ColumnMode mode = ColumnMode.valueOf(columnSet.getInt("COLUMN_TYPE"));
                    if (ColumnMode.IN != mode && ColumnMode.OUT != mode && ColumnMode.INOUT != mode) continue;
                    StoredProcedureColumn column = new StoredProcedureColumn();
                    column.setName(columnSet.getString("COLUMN_NAME"));
                    column.setMode(mode);
                    column.setJdbcType(JDBCType.valueOf(columnSet.getInt("DATA_TYPE")));
                    columnList.add(column);
                }
                String template = columnList.stream().map(StoredProcedureColumn::toProcedureParameterString).collect(Collectors.joining(", ", procedureName + "(", ")"));
                storedProcedureMetadata.setTemplate(template);
                storedProcedureMetadata.setColumnList(columnList);
                StoredProcedureMetadata storedProcedureMetadata2 = storedProcedureMetadata;
                return storedProcedureMetadata2;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, StoredProcedureMetadata> getStoredProcedures(Map<String, Object> parameters) {
        HashMap<String, StoredProcedureMetadata> storedProcedures = new HashMap<String, StoredProcedureMetadata>();
        try (Connection connection = DriverManager.getConnection(String.valueOf(parameters.get("url")), String.valueOf(parameters.get("user")), String.valueOf(parameters.get("password")));){
            DatabaseMetaData meta = connection.getMetaData();
            String catalog = parameters.getOrDefault("catalog", null);
            String defaultSchema = DatabaseMetaDataHelper.getDefaultSchema(meta.getDatabaseProductName(), String.valueOf(parameters.get("user")));
            String schemaPattern = (String)parameters.getOrDefault("schema-pattern", defaultSchema);
            String procedurePattern = parameters.getOrDefault("procedure-pattern", null);
            try (ResultSet procedureSet = DatabaseMetaDataHelper.fetchProcedures(meta, catalog, schemaPattern, procedurePattern);){
                while (procedureSet.next()) {
                    String name = procedureSet.getString("PROCEDURE_NAME");
                    StoredProcedureMetadata storedProcedureMetadata = this.getStoredProcedureMetadata(connection, catalog, schemaPattern, name);
                    storedProcedureMetadata.setName(procedureSet.getString("PROCEDURE_NAME"));
                    storedProcedureMetadata.setType(procedureSet.getString("PROCEDURE_TYPE"));
                    storedProcedureMetadata.setRemark(procedureSet.getString("REMARKS"));
                    storedProcedures.put(storedProcedureMetadata.getName(), storedProcedureMetadata);
                }
            }
            HashMap<String, StoredProcedureMetadata> hashMap = storedProcedures;
            return hashMap;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

