/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql.stored;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONBeanUtil {
    public static Properties parsePropertiesFromJSONBean(String json) throws JSONException {
        Properties properties = new Properties();
        JSONObject obj = new JSONObject(json);
        Iterator iterator = obj.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = String.valueOf(obj.get(key));
            properties.setProperty(key, value);
        }
        return properties;
    }

    public static String toJSONBean(Map<String, Object> map) {
        JSONObject obj = new JSONObject();
        for (String key : map.keySet()) {
            if (key.startsWith("#")) continue;
            obj.put(key, map.get(key));
        }
        return obj.toString();
    }

    public static String toJSONBean(List<Object> list) {
        String json = null;
        if (list.size() == 1) {
            Map map = (Map)list.get(0);
            json = JSONBeanUtil.toJSONBean(map);
        } else if (list.size() > 1) {
            StringBuilder stringBuilder = new StringBuilder("[");
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                stringBuilder.append(JSONBeanUtil.toJSONBean(map));
                if (i >= list.size() - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
            json = stringBuilder.toString();
        }
        return json;
    }
}

