/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql;

import io.syndesis.connector.sql.DatabaseMetaDataHelper;
import io.syndesis.connector.sql.SqlParam;
import io.syndesis.connector.sql.SqlStatementMetaData;
import io.syndesis.connector.sql.StatementType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SqlStatementParser {
    private Connection connection;
    private String schema;
    private SqlStatementMetaData statementInfo;
    private List<String> sqlArray = new ArrayList<String>();

    public SqlStatementParser(Connection connection, String schema, String sql) {
        this.statementInfo = new SqlStatementMetaData(sql.trim());
        this.connection = connection;
        this.schema = schema;
    }

    public SqlStatementMetaData parseSelectOnly() throws SQLException {
        DatabaseMetaData meta = this.connection.getMetaData();
        this.statementInfo.setTablesInSchema(DatabaseMetaDataHelper.fetchTables(meta, null, this.schema, null));
        this.sqlArray = this.splitSqlStatement(this.statementInfo.getSqlStatement());
        switch (this.sqlArray.get(0).toUpperCase()) {
            case "SELECT": {
                this.parseSelect(meta);
                if (this.statementInfo.getInParams().isEmpty()) break;
                throw new SQLException("Your statement is invalid and cannot contain input parameters");
            }
            default: {
                throw new SQLException("Your statement is invalid and should start with SELECT");
            }
        }
        return this.statementInfo;
    }

    public SqlStatementMetaData parse() throws SQLException {
        DatabaseMetaData meta = this.connection.getMetaData();
        this.statementInfo.setTablesInSchema(DatabaseMetaDataHelper.fetchTables(meta, null, this.schema, null));
        this.sqlArray = this.splitSqlStatement(this.statementInfo.getSqlStatement());
        switch (this.sqlArray.get(0).toUpperCase()) {
            case "INSERT": {
                this.parseInsert(meta);
                break;
            }
            case "UPDATE": {
                this.parseUpdate(meta);
                break;
            }
            case "DELETE": {
                this.parseDelete(meta);
                break;
            }
            case "SELECT": {
                this.parseSelect(meta);
                break;
            }
            default: {
                throw new SQLException("Your statement is invalid and should start with INSERT, UPDATE, SELECT or DELETE");
            }
        }
        return this.statementInfo;
    }

    private void parseInsert(DatabaseMetaData meta) throws SQLException {
        this.statementInfo.setStatementType(StatementType.INSERT);
        String tableNameInsert = this.statementInfo.addTable(this.sqlArray.get(2));
        if (this.statementInfo.hasInputParams()) {
            List<SqlParam> inputParams = this.findInsertParams(tableNameInsert);
            if (inputParams.get(0).getColumn() != null) {
                this.statementInfo.setInParams(DatabaseMetaDataHelper.getJDBCInfoByColumnNames(meta, null, this.schema, tableNameInsert, inputParams));
            } else {
                this.statementInfo.setInParams(DatabaseMetaDataHelper.getJDBCInfoByColumnOrder(meta, null, this.schema, tableNameInsert, inputParams));
            }
        }
    }

    private void parseUpdate(DatabaseMetaData meta) throws SQLException {
        this.statementInfo.setStatementType(StatementType.UPDATE);
        String tableNameUpdate = this.statementInfo.addTable(this.sqlArray.get(1));
        if (this.statementInfo.hasInputParams()) {
            List<SqlParam> inputParams = this.findInputParams();
            this.statementInfo.setInParams(DatabaseMetaDataHelper.getJDBCInfoByColumnNames(meta, null, this.schema, tableNameUpdate, inputParams));
        }
    }

    private void parseDelete(DatabaseMetaData meta) throws SQLException {
        this.statementInfo.setStatementType(StatementType.DELETE);
        String tableNameDelete = this.statementInfo.addTable(this.sqlArray.get(2));
        if (this.statementInfo.hasInputParams()) {
            List<SqlParam> inputParams = this.findInputParams();
            this.statementInfo.setInParams(DatabaseMetaDataHelper.getJDBCInfoByColumnNames(meta, null, this.schema, tableNameDelete, inputParams));
        }
    }

    private void parseSelect(DatabaseMetaData meta) throws SQLException {
        this.statementInfo.setStatementType(StatementType.SELECT);
        if (this.statementInfo.hasInputParams()) {
            List<SqlParam> inputParams = this.findInputParams();
            this.statementInfo.setTableNames(this.findTablesInSelectStatement());
            this.statementInfo.setInParams(DatabaseMetaDataHelper.getJDBCInfoByColumnNames(meta, null, this.schema, this.statementInfo.getTableNames().get(0), inputParams));
        }
        this.statementInfo.setOutParams(DatabaseMetaDataHelper.getOutputColumnInfo(this.connection, this.statementInfo.getDefaultedSqlStatement()));
    }

    List<String> splitSqlStatement(String sql) {
        String[] segments;
        ArrayList<String> sqlArray = new ArrayList<String>();
        for (String segment : segments = sql.split("=|\\,|\\s|\\(|\\)")) {
            if ("".equals(segment)) continue;
            sqlArray.add(segment);
        }
        return sqlArray;
    }

    List<SqlParam> findInsertParams(String tableName) {
        boolean isColumnName = false;
        ArrayList<String> columnNames = new ArrayList<String>();
        for (String word : this.sqlArray) {
            if ("VALUES".equals(word)) {
                isColumnName = false;
            }
            if (isColumnName) {
                columnNames.add(word);
            }
            if (!tableName.equals(word)) continue;
            isColumnName = true;
        }
        List<SqlParam> params = this.findInputParams();
        if (columnNames.size() == params.size()) {
            for (int i = 0; i < params.size(); ++i) {
                params.get(i).setColumn(((String)columnNames.get(i)).toUpperCase());
            }
        }
        return params;
    }

    List<SqlParam> findInputParams() {
        ArrayList<SqlParam> params = new ArrayList<SqlParam>();
        int i = 0;
        int columnPos = 0;
        for (String word : this.sqlArray) {
            if (word.startsWith(":#")) {
                SqlParam param = new SqlParam(word.substring(2));
                String column = this.sqlArray.get(i - 1);
                if ("LIKE".equals(column)) {
                    column = this.sqlArray.get(i - 2);
                }
                if (column.startsWith(":#") || "VALUES".equals(column)) {
                    param.setColumnPos(columnPos++);
                } else {
                    param.setColumn(column.toUpperCase());
                }
                params.add(param);
            }
            ++i;
        }
        return params;
    }

    List<SqlParam> findOutputColumnsInSelectStatement() {
        boolean isParam = true;
        ArrayList<SqlParam> params = new ArrayList<SqlParam>();
        for (String word : this.sqlArray) {
            if (isParam && !"SELECT".equals(word) && !"DISTINCT".equals(word)) {
                SqlParam param = new SqlParam(word);
                param.setColumn(word);
            }
            if (!"FROM".equals(word)) continue;
            isParam = false;
            break;
        }
        return params;
    }

    List<String> findTablesInSelectStatement() {
        boolean isTable = false;
        ArrayList<String> tables = new ArrayList<String>();
        for (String word : this.sqlArray) {
            if (!this.statementInfo.getTablesInSchema().contains(word)) {
                isTable = false;
            }
            if (isTable) {
                tables.add(word);
            }
            if (!"FROM".equals(word)) continue;
            isTable = true;
        }
        return tables;
    }
}

