/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql;

import io.syndesis.connector.sql.SqlParam;
import io.syndesis.connector.sql.StatementType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class SqlStatementMetaData {
    private Enum<StatementType> statementType;
    private List<SqlParam> inParams = new ArrayList<SqlParam>();
    private List<SqlParam> outParams = new ArrayList<SqlParam>();
    private List<String> tableNames = new ArrayList<String>();
    private String sqlStatement;
    private String camelSqlStatement;
    private Set<String> tablesInSchema;
    private String schema;
    private String defaultedSqlStatement;

    public SqlStatementMetaData(String sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    public String addTable(String tableName) throws SQLException {
        if (!this.tablesInSchema.contains(tableName)) {
            throw new SQLException("Table does not exist in schema " + this.schema);
        }
        this.tableNames.add(tableName);
        return tableName;
    }

    public boolean hasInputParams() {
        return this.sqlStatement.contains(":#");
    }

    public int numberOfInputParams() {
        int fromIndex = 0;
        int numberOfInputParams = 0;
        while (fromIndex >= 0) {
            fromIndex = this.sqlStatement.indexOf(":", fromIndex);
            ++numberOfInputParams;
        }
        return numberOfInputParams;
    }

    public String getCamelSqlStatement() {
        if (this.camelSqlStatement == null) {
            this.camelSqlStatement = this.sqlStatement;
            for (SqlParam param : this.inParams) {
                this.camelSqlStatement = this.camelSqlStatement.replace(":" + param.getName(), ":#" + param.getName());
            }
        }
        return this.camelSqlStatement;
    }

    public String getDefaultedSqlStatement() {
        List<Class> stringTypes = Arrays.asList(String.class, Character.class);
        if (this.defaultedSqlStatement == null) {
            this.defaultedSqlStatement = this.sqlStatement;
            for (SqlParam param : this.inParams) {
                if (stringTypes.contains(param.getTypeValue().getClazz())) {
                    this.defaultedSqlStatement = this.defaultedSqlStatement.replace(":#" + param.getName(), "'" + param.getTypeValue().getSampleValue().toString() + "'");
                    continue;
                }
                this.defaultedSqlStatement = this.defaultedSqlStatement.replace(":#" + param.getName(), param.getTypeValue().getSampleValue().toString());
            }
        }
        return this.defaultedSqlStatement;
    }

    public Enum<StatementType> getStatementType() {
        return this.statementType;
    }

    public List<SqlParam> getInParams() {
        return this.inParams;
    }

    public List<SqlParam> getOutParams() {
        return this.outParams;
    }

    public List<String> getTableNames() {
        return this.tableNames;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public Set<String> getTablesInSchema() {
        return this.tablesInSchema;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setStatementType(Enum<StatementType> statementType) {
        this.statementType = statementType;
    }

    public void setInParams(List<SqlParam> inParams) {
        this.inParams = inParams;
    }

    public void setOutParams(List<SqlParam> outParams) {
        this.outParams = outParams;
    }

    public void setTableNames(List<String> tableNames) {
        this.tableNames = tableNames;
    }

    public void setSqlStatement(String sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    public void setCamelSqlStatement(String camelSqlStatement) {
        this.camelSqlStatement = camelSqlStatement;
    }

    public void setTablesInSchema(Set<String> tablesInSchema) {
        this.tablesInSchema = tablesInSchema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setDefaultedSqlStatement(String defaultedSqlStatement) {
        this.defaultedSqlStatement = defaultedSqlStatement;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlStatementMetaData)) {
            return false;
        }
        SqlStatementMetaData other = (SqlStatementMetaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Enum<StatementType> this$statementType = this.getStatementType();
        Enum<StatementType> other$statementType = other.getStatementType();
        if (this$statementType == null ? other$statementType != null : !this$statementType.equals(other$statementType)) {
            return false;
        }
        List<SqlParam> this$inParams = this.getInParams();
        List<SqlParam> other$inParams = other.getInParams();
        if (this$inParams == null ? other$inParams != null : !((Object)this$inParams).equals(other$inParams)) {
            return false;
        }
        List<SqlParam> this$outParams = this.getOutParams();
        List<SqlParam> other$outParams = other.getOutParams();
        if (this$outParams == null ? other$outParams != null : !((Object)this$outParams).equals(other$outParams)) {
            return false;
        }
        List<String> this$tableNames = this.getTableNames();
        List<String> other$tableNames = other.getTableNames();
        if (this$tableNames == null ? other$tableNames != null : !((Object)this$tableNames).equals(other$tableNames)) {
            return false;
        }
        String this$sqlStatement = this.getSqlStatement();
        String other$sqlStatement = other.getSqlStatement();
        if (this$sqlStatement == null ? other$sqlStatement != null : !this$sqlStatement.equals(other$sqlStatement)) {
            return false;
        }
        String this$camelSqlStatement = this.getCamelSqlStatement();
        String other$camelSqlStatement = other.getCamelSqlStatement();
        if (this$camelSqlStatement == null ? other$camelSqlStatement != null : !this$camelSqlStatement.equals(other$camelSqlStatement)) {
            return false;
        }
        Set<String> this$tablesInSchema = this.getTablesInSchema();
        Set<String> other$tablesInSchema = other.getTablesInSchema();
        if (this$tablesInSchema == null ? other$tablesInSchema != null : !((Object)this$tablesInSchema).equals(other$tablesInSchema)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$defaultedSqlStatement = this.getDefaultedSqlStatement();
        String other$defaultedSqlStatement = other.getDefaultedSqlStatement();
        return !(this$defaultedSqlStatement == null ? other$defaultedSqlStatement != null : !this$defaultedSqlStatement.equals(other$defaultedSqlStatement));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlStatementMetaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Enum<StatementType> $statementType = this.getStatementType();
        result = result * 59 + ($statementType == null ? 43 : $statementType.hashCode());
        List<SqlParam> $inParams = this.getInParams();
        result = result * 59 + ($inParams == null ? 43 : ((Object)$inParams).hashCode());
        List<SqlParam> $outParams = this.getOutParams();
        result = result * 59 + ($outParams == null ? 43 : ((Object)$outParams).hashCode());
        List<String> $tableNames = this.getTableNames();
        result = result * 59 + ($tableNames == null ? 43 : ((Object)$tableNames).hashCode());
        String $sqlStatement = this.getSqlStatement();
        result = result * 59 + ($sqlStatement == null ? 43 : $sqlStatement.hashCode());
        String $camelSqlStatement = this.getCamelSqlStatement();
        result = result * 59 + ($camelSqlStatement == null ? 43 : $camelSqlStatement.hashCode());
        Set<String> $tablesInSchema = this.getTablesInSchema();
        result = result * 59 + ($tablesInSchema == null ? 43 : ((Object)$tablesInSchema).hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $defaultedSqlStatement = this.getDefaultedSqlStatement();
        result = result * 59 + ($defaultedSqlStatement == null ? 43 : $defaultedSqlStatement.hashCode());
        return result;
    }

    public String toString() {
        return "SqlStatementMetaData(statementType=" + this.getStatementType() + ", inParams=" + this.getInParams() + ", outParams=" + this.getOutParams() + ", tableNames=" + this.getTableNames() + ", sqlStatement=" + this.getSqlStatement() + ", camelSqlStatement=" + this.getCamelSqlStatement() + ", tablesInSchema=" + this.getTablesInSchema() + ", schema=" + this.getSchema() + ", defaultedSqlStatement=" + this.getDefaultedSqlStatement() + ")";
    }
}

