/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql;

import java.math.BigDecimal;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class SqlParam {
    private String name;
    private String column;
    private JDBCType jdbcType;
    private int columnPos;
    private TypeValue<?> typeValue;

    public SqlParam() {
    }

    public SqlParam(String name) {
        this.name = name;
    }

    public void setJdbcType(JDBCType jdbcType) {
        this.jdbcType = jdbcType;
        this.typeValue = SqlParam.javaType(jdbcType);
    }

    static TypeValue<?> javaType(JDBCType jdbcType) {
        SqlParam sqlParam = new SqlParam();
        switch (jdbcType) {
            case ARRAY: 
            case BINARY: 
            case BLOB: 
            case LONGVARBINARY: 
            case VARBINARY: {
                SqlParam sqlParam2 = sqlParam;
                sqlParam2.getClass();
                return sqlParam2.new TypeValue<List>(List.class, SqlSampleValue.arrayValue);
            }
            case BIT: 
            case BOOLEAN: {
                SqlParam sqlParam3 = sqlParam;
                sqlParam3.getClass();
                return sqlParam3.new TypeValue<Boolean>(Boolean.class, SqlSampleValue.booleanValue);
            }
            case CHAR: {
                SqlParam sqlParam4 = sqlParam;
                sqlParam4.getClass();
                return sqlParam4.new TypeValue<Character>(Character.class, SqlSampleValue.charValue);
            }
            case CLOB: 
            case DATALINK: 
            case LONGNVARCHAR: 
            case LONGVARCHAR: 
            case NCHAR: 
            case NCLOB: 
            case NVARCHAR: 
            case ROWID: 
            case SQLXML: 
            case VARCHAR: {
                SqlParam sqlParam5 = sqlParam;
                sqlParam5.getClass();
                return sqlParam5.new TypeValue<String>(String.class, SqlSampleValue.stringValue);
            }
            case DATE: {
                SqlParam sqlParam6 = sqlParam;
                sqlParam6.getClass();
                return sqlParam6.new TypeValue<java.sql.Date>(java.sql.Date.class, SqlSampleValue.dateValue);
            }
            case TIME: {
                SqlParam sqlParam7 = sqlParam;
                sqlParam7.getClass();
                return sqlParam7.new TypeValue<Time>(Time.class, SqlSampleValue.timeValue);
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIMEZONE: 
            case TIME_WITH_TIMEZONE: {
                SqlParam sqlParam8 = sqlParam;
                sqlParam8.getClass();
                return sqlParam8.new TypeValue<Timestamp>(Timestamp.class, SqlSampleValue.timestampValue);
            }
            case DECIMAL: 
            case NUMERIC: {
                SqlParam sqlParam9 = sqlParam;
                sqlParam9.getClass();
                return sqlParam9.new TypeValue<BigDecimal>(BigDecimal.class, SqlSampleValue.decimalValue);
            }
            case FLOAT: 
            case DOUBLE: {
                SqlParam sqlParam10 = sqlParam;
                sqlParam10.getClass();
                return sqlParam10.new TypeValue<Double>(Double.class, SqlSampleValue.doubleValue);
            }
            case REAL: {
                SqlParam sqlParam11 = sqlParam;
                sqlParam11.getClass();
                return sqlParam11.new TypeValue<Float>(Float.class, SqlSampleValue.floatValue);
            }
            case BIGINT: {
                SqlParam sqlParam12 = sqlParam;
                sqlParam12.getClass();
                return sqlParam12.new TypeValue<Long>(Long.class, SqlSampleValue.longValue);
            }
            case SMALLINT: 
            case INTEGER: 
            case TINYINT: {
                SqlParam sqlParam13 = sqlParam;
                sqlParam13.getClass();
                return sqlParam13.new TypeValue<Integer>(Integer.class, SqlSampleValue.integerValue);
            }
            case NULL: {
                return null;
            }
        }
        SqlParam sqlParam14 = sqlParam;
        sqlParam14.getClass();
        return sqlParam14.new TypeValue<String>(String.class, SqlSampleValue.stringValue);
    }

    public String getName() {
        return this.name;
    }

    public String getColumn() {
        return this.column;
    }

    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    public int getColumnPos() {
        return this.columnPos;
    }

    public TypeValue<?> getTypeValue() {
        return this.typeValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setColumnPos(int columnPos) {
        this.columnPos = columnPos;
    }

    public void setTypeValue(TypeValue<?> typeValue) {
        this.typeValue = typeValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlParam)) {
            return false;
        }
        SqlParam other = (SqlParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        JDBCType this$jdbcType = this.getJdbcType();
        JDBCType other$jdbcType = other.getJdbcType();
        if (this$jdbcType == null ? other$jdbcType != null : !this$jdbcType.equals(other$jdbcType)) {
            return false;
        }
        if (this.getColumnPos() != other.getColumnPos()) {
            return false;
        }
        TypeValue<?> this$typeValue = this.getTypeValue();
        TypeValue<?> other$typeValue = other.getTypeValue();
        return !(this$typeValue == null ? other$typeValue != null : !((Object)this$typeValue).equals(other$typeValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        JDBCType $jdbcType = this.getJdbcType();
        result = result * 59 + ($jdbcType == null ? 43 : $jdbcType.hashCode());
        result = result * 59 + this.getColumnPos();
        TypeValue<?> $typeValue = this.getTypeValue();
        result = result * 59 + ($typeValue == null ? 43 : ((Object)$typeValue).hashCode());
        return result;
    }

    public String toString() {
        return "SqlParam(name=" + this.getName() + ", column=" + this.getColumn() + ", jdbcType=" + this.getJdbcType() + ", columnPos=" + this.getColumnPos() + ", typeValue=" + this.getTypeValue() + ")";
    }

    public static class SqlSampleValue {
        static List arrayValue = Arrays.asList("1", "2", "3");
        static byte[] binaryValue = new byte[]{1, 2, 3};
        static String stringValue = "abc";
        static Character charValue = Character.valueOf('a');
        static java.sql.Date dateValue = new java.sql.Date(new Date().getTime());
        static Time timeValue = new Time(new Date().getTime());
        static Timestamp timestampValue = new Timestamp(new Date().getTime());
        static BigDecimal decimalValue = BigDecimal.ZERO;
        static Boolean booleanValue = Boolean.TRUE;
        static Double doubleValue = 0.0;
        static Integer integerValue = 0;
        static Long longValue = 0L;
        static Float floatValue = Float.valueOf(0.0f);
    }

    public class TypeValue<T> {
        private Class<T> clazz;
        private T sampleValue;

        public TypeValue(Class<T> clazz, T sampleValue) {
            this.clazz = clazz;
            this.sampleValue = sampleValue;
        }

        public Class<T> getClazz() {
            return this.clazz;
        }

        public T getSampleValue() {
            return this.sampleValue;
        }

        public void setClazz(Class<T> clazz) {
            this.clazz = clazz;
        }

        public void setSampleValue(T sampleValue) {
            this.sampleValue = sampleValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeValue)) {
                return false;
            }
            TypeValue other = (TypeValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<T> this$clazz = this.getClazz();
            Class<T> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            T this$sampleValue = this.getSampleValue();
            T other$sampleValue = other.getSampleValue();
            return !(this$sampleValue == null ? other$sampleValue != null : !this$sampleValue.equals(other$sampleValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TypeValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            T $sampleValue = this.getSampleValue();
            result = result * 59 + ($sampleValue == null ? 43 : $sampleValue.hashCode());
            return result;
        }

        public String toString() {
            return "SqlParam.TypeValue(clazz=" + this.getClazz() + ", sampleValue=" + this.getSampleValue() + ")";
        }
    }
}

