/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql;

import io.syndesis.connector.sql.DatabaseProduct;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConnectorVerifierExtension
extends DefaultComponentVerifierExtension {
    private static final Logger LOG = LoggerFactory.getLogger(SqlConnectorVerifierExtension.class);

    public SqlConnectorVerifierExtension() {
        super("sql-connector");
    }

    public SqlConnectorVerifierExtension(String scheme) {
        super(scheme);
    }

    public ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"url", parameters)).error(ResultErrorHelper.requiresOption((String)"user", parameters)).error(ResultErrorHelper.requiresOption((String)"password", parameters));
        if (builder.build().getErrors().isEmpty()) {
            try {
                Connection connection = DriverManager.getConnection(parameters.get("url").toString(), String.valueOf(parameters.get("user")), String.valueOf(parameters.get("password")));
                Throwable throwable = null;
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                HashMap<String, Object> redacted = new HashMap<String, Object>(parameters);
                redacted.replace("password", "********");
                LOG.warn("Unable to connecto to database with parameters {}, SQLSTATE: {}, error code: {}", new Object[]{redacted, e.getSQLState(), e.getErrorCode(), e});
                String sqlState = e.getSQLState();
                if (sqlState == null || sqlState.length() < 2) {
                    SqlConnectorVerifierExtension.unsupportedDatabase(builder);
                }
                switch (sqlState.substring(0, 2)) {
                    case "28": {
                        builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getMessage()).parameterKey("user").parameterKey("password").build());
                        break;
                    }
                    case "08": 
                    case "3D": {
                        builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE, (String)e.getMessage()).parameterKey("url").build());
                        break;
                    }
                    default: {
                        builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.GENERIC, (String)e.getMessage()).build());
                    }
                }
            }
        }
        return builder.build();
    }

    private static void unsupportedDatabase(ResultBuilder builder) {
        String supportedDatabases = String.join((CharSequence)",", (CharSequence[])Arrays.stream(DatabaseProduct.values()).map(Enum::name).toArray(String[]::new));
        String msg = "Supported Databases are [" + supportedDatabases + "]";
        builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.UNSUPPORTED, (String)msg).build()).build();
    }

    public ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) {
        try (Connection connection = DriverManager.getConnection(parameters.get("url").toString(), String.valueOf(parameters.get("user")), String.valueOf(parameters.get("password")));){
            if (connection == null) {
                throw new SQLException("No Connection");
            }
        }
        catch (Exception e) {
            ResultErrorBuilder errorBuilder = ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)e.getMessage());
            builder.error(errorBuilder.build());
        }
    }
}

