/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql;

import io.syndesis.connector.sql.DatabaseMetaDataHelper;
import io.syndesis.connector.sql.SqlStatementMetaData;
import io.syndesis.connector.sql.SqlStatementParser;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.extension.MetaDataExtension;
import org.apache.camel.component.extension.metadata.AbstractMetaDataExtension;
import org.apache.camel.component.extension.metadata.DefaultMetaData;

public class SqlConnectorMetaDataExtension
extends AbstractMetaDataExtension {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<MetaDataExtension.MetaData> meta(Map<String, Object> properties) {
        String sqlStatement = (String)properties.get("query");
        if (sqlStatement == null) {
            DefaultMetaData metaData = new DefaultMetaData(null, null, null);
            return Optional.of(metaData);
        }
        try (Connection connection = DriverManager.getConnection(String.valueOf(properties.get("url")), String.valueOf(properties.get("user")), String.valueOf(properties.get("password")));){
            DatabaseMetaData meta = connection.getMetaData();
            String defaultSchema = DatabaseMetaDataHelper.getDefaultSchema(meta.getDatabaseProductName(), String.valueOf(properties.get("user")));
            String schemaPattern = (String)properties.getOrDefault("schema-pattern", defaultSchema);
            SqlStatementParser parser = new SqlStatementParser(connection, schemaPattern, sqlStatement);
            SqlStatementMetaData sqlStatementMetaData = this.parseStatement(parser);
            DefaultMetaData metaData = new DefaultMetaData(null, null, (Object)sqlStatementMetaData);
            Optional<DefaultMetaData> optional = Optional.of(metaData);
            return optional;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    protected SqlStatementMetaData parseStatement(SqlStatementParser parser) throws SQLException {
        return parser.parse();
    }
}

