/*
 * Decompiled with CFR 0.152.
 */
package io.syndesis.connector.sql;

import io.syndesis.connector.sql.DatabaseProduct;
import io.syndesis.connector.sql.SqlParam;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DatabaseMetaDataHelper {
    public static String getDefaultSchema(String databaseProductName, String dbUser) {
        String defaultSchema = null;
        if (databaseProductName.equalsIgnoreCase(DatabaseProduct.ORACLE.name())) {
            defaultSchema = dbUser;
        } else if (databaseProductName.equalsIgnoreCase(DatabaseProduct.POSTGRESQL.name())) {
            defaultSchema = "public";
        } else if (databaseProductName.equalsIgnoreCase(DatabaseProduct.APACHE_DERBY.nameWithSpaces())) {
            defaultSchema = dbUser != null ? dbUser.toUpperCase() : "NULL";
        }
        return defaultSchema;
    }

    public static ResultSet fetchProcedureColumns(DatabaseMetaData meta, String catalog, String schema, String procedureName) throws SQLException {
        if (meta.getDatabaseProductName().equalsIgnoreCase(DatabaseProduct.POSTGRESQL.name())) {
            return meta.getFunctionColumns(catalog, schema, procedureName, null);
        }
        return meta.getProcedureColumns(catalog, schema, procedureName, null);
    }

    public static ResultSet fetchProcedures(DatabaseMetaData meta, String catalog, String schemaPattern, String procedurePattern) throws SQLException {
        if (meta.getDatabaseProductName().equalsIgnoreCase(DatabaseProduct.POSTGRESQL.name())) {
            return meta.getFunctions(catalog, schemaPattern, procedurePattern);
        }
        return meta.getProcedures(catalog, schemaPattern, procedurePattern);
    }

    static Set<String> fetchTables(DatabaseMetaData meta, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        HashSet<String> tablesInSchema = new HashSet<String>();
        ResultSet rs = meta.getTables(catalog, schemaPattern, tableNamePattern, new String[]{"TABLE"});
        while (rs.next()) {
            tablesInSchema.add(rs.getString(3).toUpperCase());
        }
        return tablesInSchema;
    }

    static ResultSet fetchTableColumns(DatabaseMetaData meta, String catalog, String schema, String tableName, String columnName) throws SQLException {
        return meta.getColumns(catalog, schema, tableName, columnName);
    }

    static List<SqlParam> getJDBCInfoByColumnNames(DatabaseMetaData meta, String catalog, String schema, String tableName, List<SqlParam> params) throws SQLException {
        ArrayList<SqlParam> paramList = new ArrayList<SqlParam>();
        for (int i = 0; i < params.size(); ++i) {
            SqlParam param = params.get(i);
            String columnName = param.getColumn();
            ResultSet column = meta.getColumns(catalog, schema, tableName, columnName);
            if (column.getFetchSize() == 0) {
                column = meta.getColumns(catalog, schema, tableName.toLowerCase(), columnName.toLowerCase());
            }
            column.next();
            param.setJdbcType(JDBCType.valueOf(column.getInt("DATA_TYPE")));
            paramList.add(param);
        }
        return paramList;
    }

    static List<SqlParam> getJDBCInfoByColumnOrder(DatabaseMetaData meta, String catalog, String schema, String tableName, List<SqlParam> params) throws SQLException {
        ArrayList<SqlParam> paramList = new ArrayList<SqlParam>();
        ResultSet columnSet = meta.getColumns(catalog, "SA", tableName, null);
        for (int i = 0; i < params.size(); ++i) {
            columnSet.next();
            SqlParam param = params.get(i);
            param.setColumn(columnSet.getString("COLUMN_NAME"));
            param.setJdbcType(JDBCType.valueOf(columnSet.getInt("DATA_TYPE")));
            paramList.add(param);
        }
        return paramList;
    }

    static List<SqlParam> getOutputColumnInfo(Connection connection, String sqlSelectStatement) throws SQLException {
        ArrayList<SqlParam> paramList = new ArrayList<SqlParam>();
        Statement stmt = connection.createStatement();
        ResultSet resultSet = stmt.executeQuery(sqlSelectStatement);
        ResultSetMetaData metaData = resultSet.getMetaData();
        if (metaData.getColumnCount() > 0) {
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                SqlParam param = new SqlParam(metaData.getColumnName(i));
                param.setJdbcType(JDBCType.valueOf(metaData.getColumnType(i)));
                paramList.add(param);
            }
        }
        return paramList;
    }
}

