/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.plugin.security.profiles;

import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.strimzi.platform.PlatformFeatures;
import io.strimzi.plugin.security.profiles.ContainerSecurityProviderContext;
import io.strimzi.plugin.security.profiles.PodSecurityProviderContext;

public interface PodSecurityProvider {
    public void configure(PlatformFeatures var1);

    @Deprecated
    default public PodSecurityContext zooKeeperPodSecurityContext(PodSecurityProviderContext context) {
        throw new UnsupportedOperationException("ZooKeeper pods are not supported anymore");
    }

    @Deprecated
    default public SecurityContext zooKeeperContainerSecurityContext(ContainerSecurityProviderContext context) {
        throw new UnsupportedOperationException("ZooKeeper container is not supported anymore");
    }

    default public PodSecurityContext kafkaPodSecurityContext(PodSecurityProviderContext context) {
        return this.podSecurityContextOrNull(context);
    }

    default public SecurityContext kafkaContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    default public SecurityContext kafkaInitContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    default public PodSecurityContext entityOperatorPodSecurityContext(PodSecurityProviderContext context) {
        return this.podSecurityContextOrNull(context);
    }

    default public SecurityContext entityTopicOperatorContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    default public SecurityContext entityUserOperatorContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    @Deprecated
    default public SecurityContext entityOperatorTlsSidecarContainerSecurityContext(ContainerSecurityProviderContext context) {
        throw new UnsupportedOperationException("TLS Sidecar container in Entity Operator pods is not supported anymore");
    }

    default public PodSecurityContext kafkaExporterPodSecurityContext(PodSecurityProviderContext context) {
        return this.podSecurityContextOrNull(context);
    }

    default public SecurityContext kafkaExporterContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    default public PodSecurityContext cruiseControlPodSecurityContext(PodSecurityProviderContext context) {
        return this.podSecurityContextOrNull(context);
    }

    default public SecurityContext cruiseControlContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    @Deprecated
    default public PodSecurityContext jmxTransPodSecurityContext(PodSecurityProviderContext context) {
        throw new UnsupportedOperationException("JMX Trans is not supported anymore");
    }

    @Deprecated
    default public SecurityContext jmxTransContainerSecurityContext(ContainerSecurityProviderContext context) {
        throw new UnsupportedOperationException("JMX Trans is not supported anymore");
    }

    default public PodSecurityContext kafkaConnectPodSecurityContext(PodSecurityProviderContext context) {
        return this.podSecurityContextOrNull(context);
    }

    default public SecurityContext kafkaConnectContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    default public SecurityContext kafkaConnectInitContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    default public PodSecurityContext kafkaConnectBuildPodSecurityContext(PodSecurityProviderContext context) {
        return this.podSecurityContextOrNull(context);
    }

    default public SecurityContext kafkaConnectBuildContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    @Deprecated
    default public PodSecurityContext kafkaMirrorMakerPodSecurityContext(PodSecurityProviderContext context) {
        throw new UnsupportedOperationException("Mirror Maker 1 is not supported anymore");
    }

    @Deprecated
    default public SecurityContext kafkaMirrorMakerContainerSecurityContext(ContainerSecurityProviderContext context) {
        throw new UnsupportedOperationException("Mirror Maker 1 is not supported anymore");
    }

    default public PodSecurityContext bridgePodSecurityContext(PodSecurityProviderContext context) {
        return this.podSecurityContextOrNull(context);
    }

    default public SecurityContext bridgeContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    default public SecurityContext bridgeInitContainerSecurityContext(ContainerSecurityProviderContext context) {
        return this.securityContextOrNull(context);
    }

    private PodSecurityContext podSecurityContextOrNull(PodSecurityProviderContext context) {
        if (context != null) {
            return context.userSuppliedSecurityContext();
        }
        return null;
    }

    private SecurityContext securityContextOrNull(ContainerSecurityProviderContext context) {
        if (context != null) {
            return context.userSuppliedSecurityContext();
        }
        return null;
    }
}

