/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.platform;

public class KubernetesVersion
implements Comparable<KubernetesVersion> {
    private final int major;
    private final int minor;
    public static final KubernetesVersion V1_27;
    public static final KubernetesVersion MINIMAL_SUPPORTED_VERSION;
    public static final int MINIMAL_SUPPORTED_MAJOR;
    public static final int MINIMAL_SUPPORTED_MINOR;

    public KubernetesVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int hashCode() {
        return this.major << 16 ^ this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesVersion that = (KubernetesVersion)o;
        return this.major == that.major && this.minor == that.minor;
    }

    @Override
    public int compareTo(KubernetesVersion o) {
        int cmp = Integer.compare(this.major, o.major);
        if (cmp == 0) {
            cmp = Integer.compare(this.minor, o.minor);
        }
        return cmp;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    static {
        MINIMAL_SUPPORTED_VERSION = V1_27 = new KubernetesVersion(1, 27);
        MINIMAL_SUPPORTED_MAJOR = KubernetesVersion.MINIMAL_SUPPORTED_VERSION.major;
        MINIMAL_SUPPORTED_MINOR = KubernetesVersion.MINIMAL_SUPPORTED_VERSION.minor;
    }
}

