/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.rebalance;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.kafka.StatusFluent;
import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceProgress;
import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceProgressBuilder;
import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceProgressFluent;
import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class KafkaRebalanceStatusFluent<A extends KafkaRebalanceStatusFluent<A>>
extends StatusFluent<A> {
    private String sessionId;
    private KafkaRebalanceProgressBuilder progress;
    private Map<String, Object> optimizationResult;

    public KafkaRebalanceStatusFluent() {
    }

    public KafkaRebalanceStatusFluent(KafkaRebalanceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KafkaRebalanceStatus instance) {
        KafkaRebalanceStatus kafkaRebalanceStatus = instance = instance != null ? instance : new KafkaRebalanceStatus();
        if (instance != null) {
            this.withSessionId(instance.getSessionId());
            this.withProgress(instance.getProgress());
            this.withOptimizationResult(instance.getOptimizationResult());
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public A withSessionId(String sessionId) {
        this.sessionId = sessionId;
        return (A)((Object)this);
    }

    public boolean hasSessionId() {
        return this.sessionId != null;
    }

    public KafkaRebalanceProgress buildProgress() {
        return this.progress != null ? this.progress.build() : null;
    }

    public A withProgress(KafkaRebalanceProgress progress) {
        this._visitables.remove((Object)"progress");
        if (progress != null) {
            this.progress = new KafkaRebalanceProgressBuilder(progress);
            this._visitables.get((Object)"progress").add(this.progress);
        } else {
            this.progress = null;
            this._visitables.get((Object)"progress").remove((Object)this.progress);
        }
        return (A)((Object)this);
    }

    public boolean hasProgress() {
        return this.progress != null;
    }

    public ProgressNested<A> withNewProgress() {
        return new ProgressNested(null);
    }

    public ProgressNested<A> withNewProgressLike(KafkaRebalanceProgress item) {
        return new ProgressNested(item);
    }

    public ProgressNested<A> editProgress() {
        return this.withNewProgressLike(Optional.ofNullable(this.buildProgress()).orElse(null));
    }

    public ProgressNested<A> editOrNewProgress() {
        return this.withNewProgressLike(Optional.ofNullable(this.buildProgress()).orElse(new KafkaRebalanceProgressBuilder().build()));
    }

    public ProgressNested<A> editOrNewProgressLike(KafkaRebalanceProgress item) {
        return this.withNewProgressLike(Optional.ofNullable(this.buildProgress()).orElse(item));
    }

    public A addToOptimizationResult(String key, Object value) {
        if (this.optimizationResult == null && key != null && value != null) {
            this.optimizationResult = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.optimizationResult.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToOptimizationResult(Map<String, Object> map) {
        if (this.optimizationResult == null && map != null) {
            this.optimizationResult = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.optimizationResult.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromOptimizationResult(String key) {
        if (this.optimizationResult == null) {
            return (A)((Object)this);
        }
        if (key != null && this.optimizationResult != null) {
            this.optimizationResult.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromOptimizationResult(Map<String, Object> map) {
        if (this.optimizationResult == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.optimizationResult == null) continue;
                this.optimizationResult.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getOptimizationResult() {
        return this.optimizationResult;
    }

    public <K, V> A withOptimizationResult(Map<String, Object> optimizationResult) {
        this.optimizationResult = optimizationResult == null ? null : new LinkedHashMap<String, Object>(optimizationResult);
        return (A)((Object)this);
    }

    public boolean hasOptimizationResult() {
        return this.optimizationResult != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaRebalanceStatusFluent that = (KafkaRebalanceStatusFluent)((Object)o);
        if (!Objects.equals(this.sessionId, that.sessionId)) {
            return false;
        }
        if (!Objects.equals((Object)this.progress, (Object)that.progress)) {
            return false;
        }
        return Objects.equals(this.optimizationResult, that.optimizationResult);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.sessionId, this.progress, this.optimizationResult, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sessionId != null) {
            sb.append("sessionId:");
            sb.append(this.sessionId + ",");
        }
        if (this.progress != null) {
            sb.append("progress:");
            sb.append(String.valueOf((Object)this.progress) + ",");
        }
        if (this.optimizationResult != null && !this.optimizationResult.isEmpty()) {
            sb.append("optimizationResult:");
            sb.append(this.optimizationResult);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ProgressNested<N>
    extends KafkaRebalanceProgressFluent<ProgressNested<N>>
    implements Nested<N> {
        KafkaRebalanceProgressBuilder builder;

        ProgressNested(KafkaRebalanceProgress item) {
            this.builder = new KafkaRebalanceProgressBuilder(this, item);
        }

        public N and() {
            return (N)KafkaRebalanceStatusFluent.this.withProgress(this.builder.build());
        }

        public N endProgress() {
            return this.and();
        }
    }
}

