/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.rebalance;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.kafka.Status;
import io.strimzi.api.kafka.model.rebalance.KafkaRebalanceProgress;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"conditions", "observedGeneration", "sessionId", "progress", "optimizationResult"})
public class KafkaRebalanceStatus
extends Status {
    private String sessionId;
    private KafkaRebalanceProgress progress;
    private Map<String, Object> optimizationResult = new HashMap<String, Object>(0);

    @Description(value="A JSON object describing the optimization result")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getOptimizationResult() {
        return this.optimizationResult;
    }

    public void setOptimizationResult(Map<String, Object> optimizationResult) {
        this.optimizationResult = optimizationResult;
    }

    @Description(value="A reference to Config Map with the progress information.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public KafkaRebalanceProgress getProgress() {
        return this.progress;
    }

    public void setProgress(KafkaRebalanceProgress progress) {
        this.progress = progress;
    }

    @Description(value="The session identifier for requests to Cruise Control pertaining to this KafkaRebalance resource. This is used by the Kafka Rebalance operator to track the status of ongoing rebalancing operations.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaRebalanceStatus)) {
            return false;
        }
        KafkaRebalanceStatus other = (KafkaRebalanceStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        KafkaRebalanceProgress this$progress = this.getProgress();
        KafkaRebalanceProgress other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress)) {
            return false;
        }
        Map<String, Object> this$optimizationResult = this.getOptimizationResult();
        Map<String, Object> other$optimizationResult = other.getOptimizationResult();
        return !(this$optimizationResult == null ? other$optimizationResult != null : !((Object)this$optimizationResult).equals(other$optimizationResult));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaRebalanceStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        KafkaRebalanceProgress $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        Map<String, Object> $optimizationResult = this.getOptimizationResult();
        result = result * 59 + ($optimizationResult == null ? 43 : ((Object)$optimizationResult).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaRebalanceStatus(super=" + super.toString() + ", sessionId=" + this.getSessionId() + ", progress=" + String.valueOf(this.getProgress()) + ", optimizationResult=" + String.valueOf(this.getOptimizationResult()) + ")";
    }
}

