/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.podset;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.strimzi.api.kafka.model.common.Spec;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.KubeLink;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"selector", "pods"})
public class StrimziPodSetSpec
extends Spec {
    private LabelSelector selector;
    private List<Map<String, Object>> pods;

    @Description(value="Selector is a label query which matches all the pods managed by this `StrimziPodSet`. Only `matchLabels` is supported. If `matchExpressions` is set, it will be ignored.")
    @KubeLink(group="meta", version="v1", kind="labelselector")
    @JsonProperty(required=true)
    public LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(LabelSelector selector) {
        this.selector = selector;
    }

    @Description(value="The Pods managed by this StrimziPodSet.")
    @KubeLink(group="core", version="v1", kind="pods")
    @JsonProperty(required=true)
    public List<Map<String, Object>> getPods() {
        return this.pods;
    }

    public void setPods(List<Map<String, Object>> pods) {
        this.pods = pods;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrimziPodSetSpec)) {
            return false;
        }
        StrimziPodSetSpec other = (StrimziPodSetSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelector this$selector = this.getSelector();
        LabelSelector other$selector = other.getSelector();
        if (this$selector == null ? other$selector != null : !this$selector.equals(other$selector)) {
            return false;
        }
        List<Map<String, Object>> this$pods = this.getPods();
        List<Map<String, Object>> other$pods = other.getPods();
        return !(this$pods == null ? other$pods != null : !((Object)this$pods).equals(other$pods));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StrimziPodSetSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LabelSelector $selector = this.getSelector();
        result = result * 59 + ($selector == null ? 43 : $selector.hashCode());
        List<Map<String, Object>> $pods = this.getPods();
        result = result * 59 + ($pods == null ? 43 : ((Object)$pods).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "StrimziPodSetSpec(super=" + super.toString() + ", selector=" + String.valueOf(this.getSelector()) + ", pods=" + String.valueOf(this.getPods()) + ")";
    }
}

