/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.nodepool;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.common.Spec;
import io.strimzi.api.kafka.model.common.template.ContainerTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.ResourceTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"podSet", "pod", "perPodService", "perPodRoute", "perPodIngress", "persistentVolumeClaim", "kafkaContainer", "initContainer"})
public class KafkaNodePoolTemplate
extends Spec {
    private ResourceTemplate podSet;
    private PodTemplate pod;
    private ResourceTemplate perPodService;
    private ResourceTemplate perPodRoute;
    private ResourceTemplate perPodIngress;
    private ResourceTemplate persistentVolumeClaim;
    private ContainerTemplate kafkaContainer;
    private ContainerTemplate initContainer;
    private Map<String, Object> additionalProperties;

    @Description(value="Template for Kafka `StrimziPodSet` resource.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPodSet() {
        return this.podSet;
    }

    public void setPodSet(ResourceTemplate podSetTemplate) {
        this.podSet = podSetTemplate;
    }

    @Description(value="Template for Kafka `Pods`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public PodTemplate getPod() {
        return this.pod;
    }

    public void setPod(PodTemplate pod) {
        this.pod = pod;
    }

    @Description(value="Template for Kafka per-pod `Services` used for access from outside of Kubernetes.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPerPodService() {
        return this.perPodService;
    }

    public void setPerPodService(ResourceTemplate perPodService) {
        this.perPodService = perPodService;
    }

    @Description(value="Template for Kafka per-pod `Ingress` used for access from outside of Kubernetes.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPerPodIngress() {
        return this.perPodIngress;
    }

    public void setPerPodIngress(ResourceTemplate perPodIngress) {
        this.perPodIngress = perPodIngress;
    }

    @Description(value="Template for all Kafka `PersistentVolumeClaims`.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPersistentVolumeClaim() {
        return this.persistentVolumeClaim;
    }

    public void setPersistentVolumeClaim(ResourceTemplate persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
    }

    @Description(value="Template for Kafka per-pod `Routes` used for access from outside of OpenShift.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ResourceTemplate getPerPodRoute() {
        return this.perPodRoute;
    }

    public void setPerPodRoute(ResourceTemplate perPodRoute) {
        this.perPodRoute = perPodRoute;
    }

    @Description(value="Template for the Kafka broker container")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ContainerTemplate getKafkaContainer() {
        return this.kafkaContainer;
    }

    public void setKafkaContainer(ContainerTemplate kafkaContainer) {
        this.kafkaContainer = kafkaContainer;
    }

    @Description(value="Template for the Kafka init container")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ContainerTemplate getInitContainer() {
        return this.initContainer;
    }

    public void setInitContainer(ContainerTemplate initContainer) {
        this.initContainer = initContainer;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties != null ? this.additionalProperties : Map.of();
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>(2);
        }
        this.additionalProperties.put(name, value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaNodePoolTemplate)) {
            return false;
        }
        KafkaNodePoolTemplate other = (KafkaNodePoolTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceTemplate this$podSet = this.getPodSet();
        ResourceTemplate other$podSet = other.getPodSet();
        if (this$podSet == null ? other$podSet != null : !((Object)this$podSet).equals(other$podSet)) {
            return false;
        }
        PodTemplate this$pod = this.getPod();
        PodTemplate other$pod = other.getPod();
        if (this$pod == null ? other$pod != null : !((Object)this$pod).equals(other$pod)) {
            return false;
        }
        ResourceTemplate this$perPodService = this.getPerPodService();
        ResourceTemplate other$perPodService = other.getPerPodService();
        if (this$perPodService == null ? other$perPodService != null : !((Object)this$perPodService).equals(other$perPodService)) {
            return false;
        }
        ResourceTemplate this$perPodRoute = this.getPerPodRoute();
        ResourceTemplate other$perPodRoute = other.getPerPodRoute();
        if (this$perPodRoute == null ? other$perPodRoute != null : !((Object)this$perPodRoute).equals(other$perPodRoute)) {
            return false;
        }
        ResourceTemplate this$perPodIngress = this.getPerPodIngress();
        ResourceTemplate other$perPodIngress = other.getPerPodIngress();
        if (this$perPodIngress == null ? other$perPodIngress != null : !((Object)this$perPodIngress).equals(other$perPodIngress)) {
            return false;
        }
        ResourceTemplate this$persistentVolumeClaim = this.getPersistentVolumeClaim();
        ResourceTemplate other$persistentVolumeClaim = other.getPersistentVolumeClaim();
        if (this$persistentVolumeClaim == null ? other$persistentVolumeClaim != null : !((Object)this$persistentVolumeClaim).equals(other$persistentVolumeClaim)) {
            return false;
        }
        ContainerTemplate this$kafkaContainer = this.getKafkaContainer();
        ContainerTemplate other$kafkaContainer = other.getKafkaContainer();
        if (this$kafkaContainer == null ? other$kafkaContainer != null : !((Object)this$kafkaContainer).equals(other$kafkaContainer)) {
            return false;
        }
        ContainerTemplate this$initContainer = this.getInitContainer();
        ContainerTemplate other$initContainer = other.getInitContainer();
        if (this$initContainer == null ? other$initContainer != null : !((Object)this$initContainer).equals(other$initContainer)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaNodePoolTemplate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ResourceTemplate $podSet = this.getPodSet();
        result = result * 59 + ($podSet == null ? 43 : ((Object)$podSet).hashCode());
        PodTemplate $pod = this.getPod();
        result = result * 59 + ($pod == null ? 43 : ((Object)$pod).hashCode());
        ResourceTemplate $perPodService = this.getPerPodService();
        result = result * 59 + ($perPodService == null ? 43 : ((Object)$perPodService).hashCode());
        ResourceTemplate $perPodRoute = this.getPerPodRoute();
        result = result * 59 + ($perPodRoute == null ? 43 : ((Object)$perPodRoute).hashCode());
        ResourceTemplate $perPodIngress = this.getPerPodIngress();
        result = result * 59 + ($perPodIngress == null ? 43 : ((Object)$perPodIngress).hashCode());
        ResourceTemplate $persistentVolumeClaim = this.getPersistentVolumeClaim();
        result = result * 59 + ($persistentVolumeClaim == null ? 43 : ((Object)$persistentVolumeClaim).hashCode());
        ContainerTemplate $kafkaContainer = this.getKafkaContainer();
        result = result * 59 + ($kafkaContainer == null ? 43 : ((Object)$kafkaContainer).hashCode());
        ContainerTemplate $initContainer = this.getInitContainer();
        result = result * 59 + ($initContainer == null ? 43 : ((Object)$initContainer).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaNodePoolTemplate(super=" + super.toString() + ", podSet=" + String.valueOf(this.getPodSet()) + ", pod=" + String.valueOf(this.getPod()) + ", perPodService=" + String.valueOf(this.getPerPodService()) + ", perPodRoute=" + String.valueOf(this.getPerPodRoute()) + ", perPodIngress=" + String.valueOf(this.getPerPodIngress()) + ", persistentVolumeClaim=" + String.valueOf(this.getPersistentVolumeClaim()) + ", kafkaContainer=" + String.valueOf(this.getKafkaContainer()) + ", initContainer=" + String.valueOf(this.getInitContainer()) + ", additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + ")";
    }
}

