/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.mirrormaker2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.connect.KafkaConnectStatus;
import io.strimzi.api.kafka.model.connector.AutoRestartStatus;
import io.strimzi.crdgenerator.annotations.Description;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"conditions", "observedGeneration", "url", "connectors", "autoRestartStatuses", "connectorPlugins", "labelSelector", "replicas"})
public class KafkaMirrorMaker2Status
extends KafkaConnectStatus {
    private List<Map<String, Object>> connectors = new ArrayList<Map<String, Object>>(3);
    private List<AutoRestartStatus> autoRestartStatuses = new ArrayList<AutoRestartStatus>();

    @Description(value="List of MirrorMaker 2 connector statuses, as reported by the Kafka Connect REST API.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Map<String, Object>> getConnectors() {
        return this.connectors;
    }

    public void setConnectors(List<Map<String, Object>> connectors) {
        this.connectors = connectors;
    }

    public synchronized void addConnector(Map<String, Object> connector) {
        this.connectors.add(connector);
        this.connectors.sort(new ConnectorsComparatorByName());
    }

    @Description(value="List of MirrorMaker 2 connector auto restart statuses")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<AutoRestartStatus> getAutoRestartStatuses() {
        return this.autoRestartStatuses;
    }

    public void setAutoRestartStatuses(List<AutoRestartStatus> autoRestartStatuses) {
        this.autoRestartStatuses = autoRestartStatuses;
    }

    public synchronized void addAutoRestartStatus(AutoRestartStatus status) {
        this.autoRestartStatuses.add(status);
        this.autoRestartStatuses.sort(Comparator.comparing(AutoRestartStatus::getConnectorName));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaMirrorMaker2Status)) {
            return false;
        }
        KafkaMirrorMaker2Status other = (KafkaMirrorMaker2Status)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Map<String, Object>> this$connectors = this.getConnectors();
        List<Map<String, Object>> other$connectors = other.getConnectors();
        if (this$connectors == null ? other$connectors != null : !((Object)this$connectors).equals(other$connectors)) {
            return false;
        }
        List<AutoRestartStatus> this$autoRestartStatuses = this.getAutoRestartStatuses();
        List<AutoRestartStatus> other$autoRestartStatuses = other.getAutoRestartStatuses();
        return !(this$autoRestartStatuses == null ? other$autoRestartStatuses != null : !((Object)this$autoRestartStatuses).equals(other$autoRestartStatuses));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaMirrorMaker2Status;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Map<String, Object>> $connectors = this.getConnectors();
        result = result * 59 + ($connectors == null ? 43 : ((Object)$connectors).hashCode());
        List<AutoRestartStatus> $autoRestartStatuses = this.getAutoRestartStatuses();
        result = result * 59 + ($autoRestartStatuses == null ? 43 : ((Object)$autoRestartStatuses).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "KafkaMirrorMaker2Status(super=" + super.toString() + ", connectors=" + String.valueOf(this.getConnectors()) + ", autoRestartStatuses=" + String.valueOf(this.getAutoRestartStatuses()) + ")";
    }

    private static class ConnectorsComparatorByName
    implements Comparator<Map<String, Object>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ConnectorsComparatorByName() {
        }

        @Override
        public int compare(Map<String, Object> m1, Map<String, Object> m2) {
            String name1 = m1.get("name") == null ? "" : m1.get("name").toString();
            String name2 = m2.get("name") == null ? "" : m2.get("name").toString();
            return name1.compareTo(name2);
        }
    }
}

