/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.kafka.quotas;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.kafka.quotas.QuotasPluginStrimzi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class QuotasPluginStrimziFluent<A extends QuotasPluginStrimziFluent<A>>
extends BaseFluent<A> {
    private Long producerByteRate;
    private Long consumerByteRate;
    private Long minAvailableBytesPerVolume;
    private Double minAvailableRatioPerVolume;
    private List<String> excludedPrincipals;

    public QuotasPluginStrimziFluent() {
    }

    public QuotasPluginStrimziFluent(QuotasPluginStrimzi instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(QuotasPluginStrimzi instance) {
        QuotasPluginStrimzi quotasPluginStrimzi = instance = instance != null ? instance : new QuotasPluginStrimzi();
        if (instance != null) {
            this.withProducerByteRate(instance.getProducerByteRate());
            this.withConsumerByteRate(instance.getConsumerByteRate());
            this.withMinAvailableBytesPerVolume(instance.getMinAvailableBytesPerVolume());
            this.withMinAvailableRatioPerVolume(instance.getMinAvailableRatioPerVolume());
            this.withExcludedPrincipals(instance.getExcludedPrincipals());
        }
    }

    public Long getProducerByteRate() {
        return this.producerByteRate;
    }

    public A withProducerByteRate(Long producerByteRate) {
        this.producerByteRate = producerByteRate;
        return (A)((Object)this);
    }

    public boolean hasProducerByteRate() {
        return this.producerByteRate != null;
    }

    public Long getConsumerByteRate() {
        return this.consumerByteRate;
    }

    public A withConsumerByteRate(Long consumerByteRate) {
        this.consumerByteRate = consumerByteRate;
        return (A)((Object)this);
    }

    public boolean hasConsumerByteRate() {
        return this.consumerByteRate != null;
    }

    public Long getMinAvailableBytesPerVolume() {
        return this.minAvailableBytesPerVolume;
    }

    public A withMinAvailableBytesPerVolume(Long minAvailableBytesPerVolume) {
        this.minAvailableBytesPerVolume = minAvailableBytesPerVolume;
        return (A)((Object)this);
    }

    public boolean hasMinAvailableBytesPerVolume() {
        return this.minAvailableBytesPerVolume != null;
    }

    public Double getMinAvailableRatioPerVolume() {
        return this.minAvailableRatioPerVolume;
    }

    public A withMinAvailableRatioPerVolume(Double minAvailableRatioPerVolume) {
        this.minAvailableRatioPerVolume = minAvailableRatioPerVolume;
        return (A)((Object)this);
    }

    public boolean hasMinAvailableRatioPerVolume() {
        return this.minAvailableRatioPerVolume != null;
    }

    public A addToExcludedPrincipals(int index, String item) {
        if (this.excludedPrincipals == null) {
            this.excludedPrincipals = new ArrayList<String>();
        }
        this.excludedPrincipals.add(index, item);
        return (A)((Object)this);
    }

    public A setToExcludedPrincipals(int index, String item) {
        if (this.excludedPrincipals == null) {
            this.excludedPrincipals = new ArrayList<String>();
        }
        this.excludedPrincipals.set(index, item);
        return (A)((Object)this);
    }

    public A addToExcludedPrincipals(String ... items) {
        if (this.excludedPrincipals == null) {
            this.excludedPrincipals = new ArrayList<String>();
        }
        for (String item : items) {
            this.excludedPrincipals.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToExcludedPrincipals(Collection<String> items) {
        if (this.excludedPrincipals == null) {
            this.excludedPrincipals = new ArrayList<String>();
        }
        for (String item : items) {
            this.excludedPrincipals.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromExcludedPrincipals(String ... items) {
        if (this.excludedPrincipals == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.excludedPrincipals.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExcludedPrincipals(Collection<String> items) {
        if (this.excludedPrincipals == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.excludedPrincipals.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getExcludedPrincipals() {
        return this.excludedPrincipals;
    }

    public String getExcludedPrincipal(int index) {
        return this.excludedPrincipals.get(index);
    }

    public String getFirstExcludedPrincipal() {
        return this.excludedPrincipals.get(0);
    }

    public String getLastExcludedPrincipal() {
        return this.excludedPrincipals.get(this.excludedPrincipals.size() - 1);
    }

    public String getMatchingExcludedPrincipal(Predicate<String> predicate) {
        for (String item : this.excludedPrincipals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingExcludedPrincipal(Predicate<String> predicate) {
        for (String item : this.excludedPrincipals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExcludedPrincipals(List<String> excludedPrincipals) {
        if (excludedPrincipals != null) {
            this.excludedPrincipals = new ArrayList<String>();
            for (String item : excludedPrincipals) {
                this.addToExcludedPrincipals(item);
            }
        } else {
            this.excludedPrincipals = null;
        }
        return (A)((Object)this);
    }

    public A withExcludedPrincipals(String ... excludedPrincipals) {
        if (this.excludedPrincipals != null) {
            this.excludedPrincipals.clear();
            this._visitables.remove((Object)"excludedPrincipals");
        }
        if (excludedPrincipals != null) {
            for (String item : excludedPrincipals) {
                this.addToExcludedPrincipals(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExcludedPrincipals() {
        return this.excludedPrincipals != null && !this.excludedPrincipals.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuotasPluginStrimziFluent that = (QuotasPluginStrimziFluent)((Object)o);
        if (!Objects.equals(this.producerByteRate, that.producerByteRate)) {
            return false;
        }
        if (!Objects.equals(this.consumerByteRate, that.consumerByteRate)) {
            return false;
        }
        if (!Objects.equals(this.minAvailableBytesPerVolume, that.minAvailableBytesPerVolume)) {
            return false;
        }
        if (!Objects.equals(this.minAvailableRatioPerVolume, that.minAvailableRatioPerVolume)) {
            return false;
        }
        return Objects.equals(this.excludedPrincipals, that.excludedPrincipals);
    }

    public int hashCode() {
        return Objects.hash(this.producerByteRate, this.consumerByteRate, this.minAvailableBytesPerVolume, this.minAvailableRatioPerVolume, this.excludedPrincipals, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.producerByteRate != null) {
            sb.append("producerByteRate:");
            sb.append(this.producerByteRate + ",");
        }
        if (this.consumerByteRate != null) {
            sb.append("consumerByteRate:");
            sb.append(this.consumerByteRate + ",");
        }
        if (this.minAvailableBytesPerVolume != null) {
            sb.append("minAvailableBytesPerVolume:");
            sb.append(this.minAvailableBytesPerVolume + ",");
        }
        if (this.minAvailableRatioPerVolume != null) {
            sb.append("minAvailableRatioPerVolume:");
            sb.append(this.minAvailableRatioPerVolume + ",");
        }
        if (this.excludedPrincipals != null && !this.excludedPrincipals.isEmpty()) {
            sb.append("excludedPrincipals:");
            sb.append(this.excludedPrincipals);
        }
        sb.append("}");
        return sb.toString();
    }
}

